import { UInt32 } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |TrustListDataType                                           |
 * | isAbstract|false                                                       |
 */
export interface DTTrustList extends DTStructure {
    specifiedLists: UInt32;
    trustedCertificates: Buffer[];
    trustedCrls: Buffer[];
    issuerCertificates: Buffer[];
    issuerCrls: Buffer[];
}
export interface UDTTrustList extends ExtensionObject, DTTrustList {
}
