import { NodeId } from "node-opcua-nodeid";
import { UInt32, Byte } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |SubscriptionDiagnosticsDataType                             |
 * | isAbstract|false                                                       |
 */
export interface DTSubscriptionDiagnostics extends DTStructure {
    sessionId: NodeId;
    subscriptionId: UInt32;
    priority: Byte;
    publishingInterval: number;
    maxKeepAliveCount: UInt32;
    maxLifetimeCount: UInt32;
    maxNotificationsPerPublish: UInt32;
    publishingEnabled: boolean;
    modifyCount: UInt32;
    enableCount: UInt32;
    disableCount: UInt32;
    republishRequestCount: UInt32;
    republishMessageRequestCount: UInt32;
    republishMessageCount: UInt32;
    transferRequestCount: UInt32;
    transferredToAltClientCount: UInt32;
    transferredToSameClientCount: UInt32;
    publishRequestCount: UInt32;
    dataChangeNotificationsCount: UInt32;
    eventNotificationsCount: UInt32;
    notificationsCount: UInt32;
    latePublishRequestCount: UInt32;
    currentKeepAliveCount: UInt32;
    currentLifetimeCount: UInt32;
    unacknowledgedMessageCount: UInt32;
    discardedMessageCount: UInt32;
    monitoredItemCount: UInt32;
    disabledMonitoredItemCount: UInt32;
    monitoringQueueOverflowCount: UInt32;
    nextSequenceNumber: UInt32;
    eventQueueOverflowCount: UInt32;
}
export interface UDTSubscriptionDiagnostics extends ExtensionObject, DTSubscriptionDiagnostics {
}
