import { NodeId } from "node-opcua-nodeid";
import { UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
import { EnumMessageSecurityMode } from "./enum_message_security_mode";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |SessionSecurityDiagnosticsDataType                          |
 * | isAbstract|false                                                       |
 */
export interface DTSessionSecurityDiagnostics extends DTStructure {
    sessionId: NodeId;
    clientUserIdOfSession: UAString;
    clientUserIdHistory: UAString[];
    authenticationMechanism: UAString;
    encoding: UAString;
    transportProtocol: UAString;
    securityMode: EnumMessageSecurityMode;
    securityPolicyUri: UAString;
    clientCertificate: Buffer;
}
export interface UDTSessionSecurityDiagnostics extends ExtensionObject, DTSessionSecurityDiagnostics {
}
