import { UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTUserIdentityToken } from "./dt_user_identity_token";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |IssuedIdentityToken                                         |
 * | isAbstract|false                                                       |
 */
export interface DTIssuedIdentityToken extends DTUserIdentityToken {
    policyId: UAString;
    tokenData: Buffer;
    encryptionAlgorithm: UAString;
}
export interface UDTIssuedIdentityToken extends ExtensionObject, DTIssuedIdentityToken {
}
