import { Byte, UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
import { DTApplicationDescription } from "./dt_application_description";
import { EnumMessageSecurityMode } from "./enum_message_security_mode";
import { DTUserTokenPolicy } from "./dt_user_token_policy";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |EndpointDescription                                         |
 * | isAbstract|false                                                       |
 */
export interface DTEndpointDescription extends DTStructure {
    endpointUrl: UAString;
    server: DTApplicationDescription;
    serverCertificate: Buffer;
    securityMode: EnumMessageSecurityMode;
    securityPolicyUri: UAString;
    userIdentityTokens: DTUserTokenPolicy[];
    transportProfileUri: UAString;
    securityLevel: Byte;
}
export interface UDTEndpointDescription extends ExtensionObject, DTEndpointDescription {
}
