import { NodeId } from "node-opcua-nodeid";
import { UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |DtlsPubSubConnectionDataType                                |
 * | isAbstract|false                                                       |
 */
export interface DTDtlsPubSubConnection extends DTStructure {
    clientCipherSuite: UAString;
    serverCipherSuites: UAString[];
    zeroRTT: boolean;
    certificateGroupId: NodeId;
    verifyClientCertificate: boolean;
}
export interface UDTDtlsPubSubConnection extends ExtensionObject, DTDtlsPubSubConnection {
}
