import { LocalizedText } from "node-opcua-data-model";
import { UInt32, UAString } from "node-opcua-basic-types";
import { ExtensionObject } from "node-opcua-extension-object";
import { DTStructure } from "./dt_structure";
/**
 * |           |                                                            |
 * |-----------|------------------------------------------------------------|
 * | namespace |http://opcfoundation.org/UA/                                |
 * | nodeClass |DataType                                                    |
 * | name      |BitFieldDefinition                                          |
 * | isAbstract|false                                                       |
 */
export interface DTBitFieldDefinition extends DTStructure {
    name: UAString;
    description: LocalizedText;
    reserved: boolean;
    startingBitPosition: UInt32;
    endingBitPosition: UInt32;
}
export interface UDTBitFieldDefinition extends ExtensionObject, DTBitFieldDefinition {
}
