"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalize_require_file = normalize_require_file;
const path_1 = __importDefault(require("path"));
// ---------------------------------------------------------------------------------------------------------------------
/**

 * @param baseFolder
 * @param fullPathToFile
 *
 *
 * @example:
 *    normalize_require_file("/home/bob/folder1/","/home/bob/folder1/folder2/toto.js").should.eql("./folder2/toto");
 */
function normalize_require_file(baseFolder, fullPathToFile) {
    let localFile = path_1.default.relative(baseFolder, fullPathToFile).replace(/\\/g, "/");
    // append ./ if necessary
    if (localFile.substring(0, 1) !== ".") {
        localFile = "./" + localFile;
    }
    // remove extension
    localFile = localFile.substring(0, localFile.length - path_1.default.extname(localFile).length);
    return localFile;
}
//# sourceMappingURL=normalize_require_file.js.map