"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verbose = void 0;
exports.generateCode = generateCode;
exports.generateTypeScriptCodeFromSchema = generateTypeScriptCodeFromSchema;
exports.registerObject = registerObject;
exports.unregisterObject = unregisterObject;
/* istanbul ignore file */
/**
 * @module node-opcua-generator
 */
// tslint:disable:max-line-length
// tslint:disable:no-console
const fs_1 = __importDefault(require("fs"));
// node 14 onward : import { mkdir } from "fs/promises";
const { mkdir } = fs_1.default.promises;
const path_1 = __importDefault(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_debug_1 = require("node-opcua-debug");
const factory_code_generator_1 = require("./factory_code_generator");
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)(__filename);
doDebug;
/**
 * @module opcua.miscellaneous
 */
function compileTScriptCode(typescriptFilename) {
    const content = fs_1.default.readFileSync(typescriptFilename, "utf-8");
    const compilerOptions = {
        module: typescript_1.default.ModuleKind.CommonJS,
        target: typescript_1.default.ScriptTarget.ES2016,
        skipLibCheck: true,
        declaration: true,
        sourceMap: true,
        strict: true,
        noImplicitAny: true,
        noImplicitReturns: true
    };
    const res1 = typescript_1.default.transpileModule(content, { compilerOptions, moduleName: "myModule2" });
    const javascriptFilename = typescriptFilename.replace(/\.ts$/, ".js");
    const sourceMapFilename = typescriptFilename.replace(/\.ts$/, ".js.map");
    fs_1.default.writeFileSync(javascriptFilename, res1.outputText, "utf-8");
    fs_1.default.writeFileSync(sourceMapFilename, res1.sourceMapText, "utf-8");
    return res1.outputText;
}
compileTScriptCode;
exports.verbose = false;
function get_caller_source_filename() {
    // let's find source code where schema file is described
    // to do make change this
    // the line has the following shape:
    //      'at blah (/home/toto/myFile.js:53:34)'
    const err = new Error("");
    const re = /.*\((.*):[0-9]*:[0-9]*\)/g;
    if (!err.stack) {
        return "";
    }
    console.log(err.stack.split("\n"));
    const ma = err.stack.split("\n");
    let m = re.exec(ma[8]);
    if (!m) {
        m = re.exec(ma[4]);
    }
    if (!m) {
        return "../";
        // throw new Error("Invalid: cannot find caller_source_filename : " + err.stack + "\n =============");
    }
    const schemaFile = m[1];
    return schemaFile;
}
async function generateCode(schemaName, localSchemaFile, generatedCodeFolder) {
    const schemaTypescriptFile = schemaName + "_Schema.ts";
    const currentFolder = process.cwd();
    //
    const localSchemaFileExists = fs_1.default.existsSync(localSchemaFile);
    if (!localSchemaFileExists) {
        throw new Error(`Cannot find source file for schema ${schemaTypescriptFile}`);
    }
    if (!generatedCodeFolder) {
        generatedCodeFolder = path_1.default.join(currentFolder, "_generated_");
    }
    const generatedCodeFolderExists = fs_1.default.existsSync(generatedCodeFolder);
    if (!generatedCodeFolderExists) {
        await mkdir(generatedCodeFolder);
    }
    const generatedTypescriptSource = path_1.default.join(generatedCodeFolder, "_" + schemaName + ".ts");
    const generatedSourceExists = fs_1.default.existsSync(generatedTypescriptSource);
    let schemaFileIsNewer = false;
    let codeGeneratorIsNewer = true;
    if (generatedSourceExists) {
        const generatedSourceMtime = new Date(fs_1.default.statSync(generatedTypescriptSource).mtime).getTime();
        const schemaFileMtime = new Date(fs_1.default.statSync(localSchemaFile).mtime).getTime();
        schemaFileIsNewer = generatedSourceMtime <= schemaFileMtime;
        let codeGeneratorScript = path_1.default.join(__dirname, "factory_code_generator.ts");
        if (!fs_1.default.existsSync(codeGeneratorScript)) {
            codeGeneratorScript = path_1.default.join(__dirname, "factory_code_generator.js");
        }
        (0, node_opcua_assert_1.assert)(fs_1.default.existsSync(codeGeneratorScript), "cannot get code factory_code_generator" + codeGeneratorScript);
        const codeGeneratorScriptMtime = new Date(fs_1.default.statSync(codeGeneratorScript).mtime).getTime();
        codeGeneratorIsNewer = generatedSourceMtime <= codeGeneratorScriptMtime;
    }
    const generatedSourceIsOutdated = !generatedSourceExists || codeGeneratorIsNewer || schemaFileIsNewer;
    if (generatedSourceIsOutdated) {
        const module = await import(localSchemaFile);
        const schema = module[schemaName + "_Schema"];
        if (!schema) {
            throw new Error(`module must export a Schema with name ${schemaName}_Schema  in ${generatedTypescriptSource}`);
        }
        debugLog(" generated_source_is_outdated ", schemaName, " to ", generatedTypescriptSource);
        if (exports.verbose) {
            console.log(" generating ", schemaName, " in ", generatedTypescriptSource);
        }
        const localSchemaFile1 = path_1.default.join("../schemas", schemaName + "_schema");
        (0, factory_code_generator_1.produce_TScript_code)(schema, localSchemaFile1, generatedTypescriptSource);
    }
}
async function generateTypeScriptCodeFromSchema(schemaName) {
    const currentFolder = process.cwd();
    const schemaFilename = path_1.default.join(currentFolder, "schemas", schemaName + "_schema.ts");
    const generatedCodeFolder = path_1.default.join(process.cwd(), "_generated_");
    await generateCode(schemaName, schemaFilename, generatedCodeFolder);
}
async function registerObject(schema, generateCodeFolder) {
    if (!schema.split) {
        console.log("error !", schema);
        // xx process.exit(1);
    }
    // we expect <schema>|<hint>
    const hintSchema = schema.split("|");
    if (hintSchema.length === 1) {
        // no hint provided
        const callerFolder = get_caller_source_filename();
        const defaultHint = path_1.default.join(path_1.default.dirname(callerFolder), "schemas");
        hintSchema.unshift(defaultHint);
        generateCodeFolder = generateCodeFolder ? generateCodeFolder : path_1.default.join(path_1.default.dirname(callerFolder), "_generated_");
    }
    const folderHint = hintSchema[0];
    schema = hintSchema[1];
    const schemaName = schema + "_Schema";
    const schemaFile = path_1.default.join(folderHint, schema + "_schema.ts");
    const module = await import(schemaFile);
    if (!module) {
        throw new Error("cannot find " + schemaFile);
    }
    await generateCode(schemaName, schemaFile, generateCodeFolder);
    return null;
}
function unregisterObject(schema, folder) {
    const generateTypeScriptSource = (0, factory_code_generator_1.get_class_TScript_filename)(schema.name, folder);
    if (fs_1.default.existsSync(generateTypeScriptSource)) {
        fs_1.default.unlinkSync(generateTypeScriptSource);
        (0, node_opcua_assert_1.assert)(!fs_1.default.existsSync(generateTypeScriptSource));
    }
}
//# sourceMappingURL=generator.js.map