import { QualifiedName } from "node-opcua-data-model";
import { NodeId } from "node-opcua-nodeid";
export interface ProxyNode {
    nodeId: NodeId;
    browseName: QualifiedName;
    $fromState: ProxyNode;
    $toState: ProxyNode;
    $components: ProxyNode[];
    typeDefinition?: {
        toString(): string;
    };
}
export declare class ProxyTransition {
    private _node;
    constructor(proxyNode: ProxyNode);
    get nodeId(): string;
    get browseName(): string;
    get fromStateNode(): ProxyNode;
    get toStateNode(): ProxyNode;
}
export declare function makeProxyTransition(node: ProxyNode): ProxyTransition;
