"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyState = void 0;
exports.makeProxyState = makeProxyState;
class ProxyState {
    _node;
    constructor(proxyNode) {
        this._node = proxyNode;
    }
    get browseName() {
        return this._node.browseName.toString();
    }
    get stateNumber() {
        // note stateNumber has no real dataValue
        return this._node.stateNumber.nodeId.value.toString();
    }
    get nodeId() {
        // note stateNumber has no real dataValue
        return this._node.nodeId;
    }
    toString() {
        return "state " + this.browseName + " stateNumber :" + this.stateNumber.toString();
    }
}
exports.ProxyState = ProxyState;
function makeProxyState(node) {
    return new ProxyState(node);
}
//# sourceMappingURL=proxy_state.js.map