/**
 * @module node-opcua-client-proxy
 */
import { EventEmitter } from "events";
import { NodeClass } from "node-opcua-data-model";
import { DataValue } from "node-opcua-data-value";
import { NodeId } from "node-opcua-nodeid";
import { Argument } from "node-opcua-service-call";
import { DataType, Variant } from "node-opcua-variant";
import { UAProxyManager } from "./proxy_manager";
import { StatusCode } from "node-opcua-status-code";
export interface ArgumentEx extends Argument {
    _basicDataType: DataType;
}
export interface MethodDescription {
    browseName: string;
    executableFlag: boolean;
    func: (input: Record<string, unknown>, callback: (err: Error | null, output?: Record<string, unknown>) => void) => void;
    nodeId: NodeId;
    inputArguments: ArgumentEx[];
    outputArguments: ArgumentEx[];
}
export declare class ProxyBaseNode extends EventEmitter {
    /**
     * the object nodeId
     * @property nodeId
     * @type {NodeId}
     */
    readonly nodeId: NodeId;
    /**
     * the object's components
     * @property $components
     * @type {Array<ProxyBaseNode>}
     */
    readonly $components: any[];
    /**
     * the object's properties
     * @property $properties
     * @type {Array<ProxyBaseNode>}
     */
    $properties: any[];
    /**
     * the object's properties
     * @property $methods
     * @type {Array<ProxyBaseNode>}
     */
    $methods: MethodDescription[];
    /**
     * the Folder's elements
     * @property $organizes
     * @type {Array<ProxyBaseNode>}
     */
    $organizes: any[];
    /**
     * the object's description
     * @property description
     * @type {String}
     */
    description: string;
    /**
     * the object's browseName
     * @property browseName
     * @type {String}
     */
    browseName: string;
    /**
     * the object's NodeClass
     * @property nodeClass
     * @type {NodeClass}
     */
    readonly nodeClass: NodeClass;
    private readonly proxyManager;
    constructor(proxyManager: UAProxyManager, nodeId: NodeId, nodeClass: NodeClass);
    /**
     * get a updated Value of the Variable , by using a ReadRequest
     */
    readValue(): Promise<Variant>;
    /**
     * set the Value of the Variable, by using a WriteRequest
     */
    writeValue(dataValue: DataValue): Promise<StatusCode>;
    toString(): string;
}
