"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeRefId = makeRefId;
/**
 * @module node-opcua-client-proxy
 */
// tslint:disable:no-shadowed-variable
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
function makeRefId(referenceTypeName) {
    const nodeId = (0, node_opcua_nodeid_1.makeNodeId)(node_opcua_constants_1.ReferenceTypeIds[referenceTypeName] || node_opcua_constants_1.ObjectTypeIds[referenceTypeName]);
    // istanbul ignore next
    if (nodeId.isEmpty()) {
        throw new Error("makeRefId: cannot find ReferenceTypeName + " + referenceTypeName);
    }
    return nodeId;
}
//# sourceMappingURL=proxy.js.map