import { Certificate } from "node-opcua-crypto/web";
import { CertificateManager } from "node-opcua-pki";
import { StatusCode } from "node-opcua-status-code";
import { StatusCodeCallback } from "node-opcua-status-code";
import { ObjectRegistry } from "node-opcua-object-registry";
export interface ICertificateManager {
    getTrustStatus(certificate: Certificate): Promise<StatusCode>;
    getTrustStatus(certificate: Certificate, callback: StatusCodeCallback): void;
    checkCertificate(certificate: Certificate): Promise<StatusCode>;
    checkCertificate(certificate: Certificate, callback: StatusCodeCallback): void;
    /**
     *
     * @param certificate
     * @param callback
     */
    trustCertificate(certificate: Certificate, callback: (err?: Error | null) => void): void;
    trustCertificate(certificate: Certificate): Promise<void>;
    rejectCertificate(certificate: Certificate, callback: (err?: Error | null) => void): void;
    rejectCertificate(certificate: Certificate): Promise<void>;
}
export interface OPCUACertificateManagerOptions {
    /**
     * where to store the PKI
     * default %APPDATA%/node-opcua-default
     */
    rootFolder?: null | string;
    automaticallyAcceptUnknownCertificate?: boolean;
    /**
     * the name of the pki store( default value = "pki" )
     *
     * the PKI folder will be <rootFolder>/<name>
     */
    name?: string;
    /**
     *
     */
    keySize?: 2048 | 3072 | 4096;
}
export declare class OPCUACertificateManager extends CertificateManager implements ICertificateManager {
    #private;
    static defaultCertificateSubject: string;
    static registry: ObjectRegistry;
    referenceCounter: number;
    automaticallyAcceptUnknownCertificate: boolean;
    constructor(options: OPCUACertificateManagerOptions);
    initialize(): Promise<void>;
    initialize(callback: (err?: Error) => void): void;
    dispose(): Promise<void>;
    checkCertificate(certificateChain: Certificate): Promise<StatusCode>;
    checkCertificate(certificateChain: Certificate, callback: StatusCodeCallback): void;
    getTrustStatus(certificate: Certificate): Promise<StatusCode>;
    getTrustStatus(certificate: Certificate, callback: StatusCodeCallback): void;
    withLock2<T>(action: () => Promise<T>): Promise<T>;
}
export declare function getDefaultCertificateManager(name: "PKI" | "UserPKI"): OPCUACertificateManager;
