import { BinaryStream, OutputBinaryStream } from "node-opcua-binary-stream";
export declare function isValidUInt16(value: number): boolean;
export type UInt8 = number;
export type UInt16 = number;
export type UInt32 = number;
export type UInt64 = UInt32[];
export type Int8 = number;
export type Int16 = number;
export type Int32 = number;
export type Int64 = UInt32[];
export type Byte = UInt8;
export type SByte = Int8;
export declare function randomUInt16(): UInt16;
export declare function encodeUInt16(value: UInt16, stream: OutputBinaryStream): void;
export declare function decodeUInt16(stream: BinaryStream, value?: number): UInt16;
export declare function isValidInt16(value: number): boolean;
export declare function randomInt16(): Int16;
export declare function encodeInt16(value: Int16, stream: OutputBinaryStream): void;
export declare function decodeInt16(stream: BinaryStream, value?: number): Int16;
export declare function isValidInt32(value: number): boolean;
export declare function randomInt32(): Int32;
export declare function encodeInt32(value: Int32, stream: OutputBinaryStream): void;
export declare function decodeInt32(stream: BinaryStream, value?: number): Int32;
export declare function isValidUInt32(value: number): boolean;
export declare function randomUInt32(): UInt32;
export declare function encodeUInt32(value: UInt32, stream: OutputBinaryStream): void;
export declare function decodeUInt32(stream: BinaryStream, value?: number): UInt32;
export declare function isValidInt8(value: number): boolean;
export declare function randomInt8(): Int8;
export declare function encodeInt8(value: Int8, stream: OutputBinaryStream): void;
export declare function decodeInt8(stream: BinaryStream, value?: number): Int8;
export declare const isValidSByte: typeof isValidInt8;
export declare const randomSByte: typeof randomInt8;
export declare const encodeSByte: typeof encodeInt8;
export declare const decodeSByte: typeof decodeInt8;
export declare function isValidUInt8(value: number): boolean;
export declare function randomUInt8(): UInt8;
export declare function encodeUInt8(value: UInt8, stream: OutputBinaryStream): void;
export declare function decodeUInt8(stream: BinaryStream, value?: number): UInt8;
export declare const isValidByte: typeof isValidUInt8;
export declare const randomByte: typeof randomUInt8;
export declare const encodeByte: typeof encodeUInt8;
export declare const decodeByte: typeof decodeUInt8;
export declare function isValidUInt64(value?: number | number[]): boolean;
export declare function randomUInt64(): UInt64;
export declare function encodeUInt64(value: UInt64 | number, stream: OutputBinaryStream): void;
export declare function decodeUInt64(stream: BinaryStream, value?: UInt64): UInt64;
export declare function constructInt64(high: UInt32, low: UInt32): Int64;
export declare function coerceUInt64(value: number | UInt64 | Int32 | string | null): UInt64;
export declare function randomInt64(): Int64;
export declare const coerceInt64: typeof coerceUInt64;
export declare const isValidInt64: typeof isValidUInt64;
export declare const encodeInt64: typeof encodeUInt64;
export declare const decodeInt64: typeof decodeUInt64;
export declare function coerceInt8(value: number | string | null): Int8;
export declare function coerceUInt8(value: number | string | null): UInt8;
export declare function coerceByte(value: number | string | null): UInt8;
export declare function coerceSByte(value: number | string | null): Int8;
export declare function coerceUInt16(value: number | string | null): UInt16;
export declare function coerceInt16(value: number | string | null): Int16;
interface EnumItemLike {
    value: number;
}
export declare function coerceUInt32(value: null | string | number | EnumItemLike): UInt32;
export declare function coerceInt32(value: null | Int64 | UInt64 | number | string): Int32;
export declare function Int64ToBigInt(value: Int64): bigint;
export declare function UInt64ToBigInt(value: UInt64): bigint;
export declare function coerceInt64toInt32(value: Int64 | Int32): Int32;
export declare function coerceUInt64toInt32(value: UInt64 | UInt32): Int32;
export {};
