"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dumpEvent = dumpEvent;
const chalk_1 = __importDefault(require("chalk"));
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_debug_1 = require("node-opcua-debug");
const traceLog = (0, node_opcua_debug_1.make_traceLog)("ClientAlarmTool");
/**
 *
 * @param session
 * @param fields
 * @param eventFields
 */
async function dumpEvent(session, fields, eventFields) {
    async function getBrowseName(_session, nodeId) {
        const dataValue = await _session.read({
            attributeId: node_opcua_data_model_1.AttributeIds.BrowseName,
            nodeId
        });
        if (dataValue.statusCode.isGood()) {
            const browseName = dataValue.value.value.name;
            return browseName;
        }
        else {
            return "???";
        }
    }
    function w(str, l) {
        return (str || "").toString().padEnd(l, " ").substring(0, l);
    }
    async function __dumpEvent1(_session, _fields, variant, index) {
        if (variant.dataType === node_opcua_variant_1.DataType.Null) {
            return;
        }
        if (variant.dataType === node_opcua_variant_1.DataType.NodeId) {
            const name = await getBrowseName(_session, variant.value);
            traceLog(chalk_1.default.yellow(w(name, 30), w(_fields[index], 25)), chalk_1.default.cyan(w(node_opcua_variant_1.DataType[variant.dataType], 10).toString()), chalk_1.default.cyan.bold(name), "(", w(variant.value, 20), ")");
        }
        else {
            // tslint:disable-next-line: no-console
            traceLog(chalk_1.default.yellow(w("", 30), w(_fields[index], 25)), chalk_1.default.cyan(w(node_opcua_variant_1.DataType[variant.dataType], 10).toString()), variant.value);
        }
    }
    async function __dumpEvent(_session, _fields, _eventFields) {
        let index = 0;
        const promises = [];
        for (const variant of _eventFields) {
            promises.push(__dumpEvent1(_session, _fields, variant, index));
            index++;
        }
        await Promise.all(promises);
    }
    await __dumpEvent(session, fields, eventFields);
}
//# sourceMappingURL=client_alarm_tools_dump_event.js.map