import { EventEmitter } from "events";
import { EventStuff } from "./event_stuff";
import { ClientAlarm } from "./client_alarm";
export interface ClientAlarmList {
    on(eventName: "alarmChanged", handler: (alarm: ClientAlarm) => void): this;
    on(eventName: "alarmDeleted", handler: (alarm: ClientAlarm) => void): this;
    on(eventName: "newAlarm", handler: (alarm: ClientAlarm) => void): this;
    emit(eventName: "alarmChanged", alarm: ClientAlarm): boolean;
    emit(eventName: "newAlarm", alarm: ClientAlarm): boolean;
    emit(eventName: "alarmDeleted", alarm: ClientAlarm): boolean;
}
export declare class ClientAlarmList extends EventEmitter implements Iterable<ClientAlarm> {
    private _map;
    constructor();
    [Symbol.iterator](): Iterator<ClientAlarm>;
    alarms(): ClientAlarm[];
    update(eventField: EventStuff): void;
    removeAlarm(eventField: EventStuff): void;
    get length(): number;
    purgeUnusedAlarms(): void;
    private _removeAlarm;
    private makeKey;
    private findAlarm;
    private deleteAlarm;
}
