"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAlarm = void 0;
const events_1 = require("events");
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_variant_1 = require("node-opcua-variant");
const call_method_condition_1 = require("./call_method_condition");
/**
 * describes a OPCUA Alarm as seen in the client side
 */
class ClientAlarm extends events_1.EventEmitter {
    conditionId;
    eventType;
    eventId;
    fields;
    constructor(eventFields) {
        super();
        this.conditionId = (0, node_opcua_nodeid_1.resolveNodeId)(eventFields.conditionId.value);
        this.eventType = (0, node_opcua_nodeid_1.resolveNodeId)(eventFields.eventType.value);
        this.eventId = eventFields.eventId.value;
        this.fields = eventFields;
        this.update(eventFields);
    }
    async acknowledge(session, comment) {
        return await (0, call_method_condition_1.acknowledgeCondition)(session, this.conditionId, this.eventId, comment);
    }
    async confirm(session, comment) {
        return await (0, call_method_condition_1.confirmCondition)(session, this.conditionId, this.eventId, comment);
    }
    update(eventFields) {
        (0, node_opcua_assert_1.assert)(this.conditionId.toString() === (0, node_opcua_nodeid_1.resolveNodeId)(eventFields.conditionId.value).toString());
        (0, node_opcua_assert_1.assert)(this.eventType.toString() === (0, node_opcua_nodeid_1.resolveNodeId)(eventFields.eventType.value).toString());
        this.eventId = eventFields.eventId.value;
        this.fields = eventFields;
    }
    getRetain() {
        return this.fields.retain.value;
    }
    toString() {
        return (this.constructor.name +
            ": " +
            this.conditionId.toString() +
            " " +
            this.eventType.toString() +
            " " +
            Object.entries(this.fields)
                .filter(([key, value]) => value.dataType !== node_opcua_variant_1.DataType.Null)
                .map(([key, value]) => key.padEnd(30) + "=" + value.toString())
                .join("\n") +
            "\n\n");
    }
    getField(fieldName) {
        return this.fields[fieldName] || null;
    }
}
exports.ClientAlarm = ClientAlarm;
//# sourceMappingURL=client_alarm.js.map