"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.callConditionRefresh = callConditionRefresh;
const node_opcua_assert_1 = __importDefault(require("node-opcua-assert"));
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_service_translate_browse_path_1 = require("node-opcua-service-translate-browse-path");
const node_opcua_types_1 = require("node-opcua-types");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_debug_1 = require("node-opcua-debug");
const doDebug = false;
const debugLog = (0, node_opcua_debug_1.make_debugLog)("A&E");
const warningLog = (0, node_opcua_debug_1.make_warningLog)("A&E");
async function callConditionRefresh(session, subscriptionId) {
    (0, node_opcua_assert_1.default)(isFinite(subscriptionId), "May be subscription is not yet initialized");
    const conditionTypeNodeId = (0, node_opcua_nodeid_1.resolveNodeId)("ConditionType");
    let conditionRefreshId = (0, node_opcua_nodeid_1.resolveNodeId)("ConditionType_ConditionRefresh");
    // find conditionRefreshId
    const browsePath = (0, node_opcua_service_translate_browse_path_1.makeBrowsePath)(conditionTypeNodeId, ".ConditionRefresh");
    const translateResult = await session.translateBrowsePath(browsePath);
    // istanbul ignore next
    if (translateResult.targets && translateResult.targets.length > 0) {
        conditionRefreshId = translateResult.targets[0].targetId;
    }
    else {
        // cannot find conditionRefreshId
        return node_opcua_status_code_1.StatusCodes.BadInternalError;
    }
    const methodToCall = {
        inputArguments: [new node_opcua_variant_1.Variant({ dataType: node_opcua_basic_types_1.DataType.UInt32, value: subscriptionId })],
        methodId: conditionRefreshId,
        objectId: conditionTypeNodeId
    };
    doDebug && debugLog("Calling method ", new node_opcua_types_1.CallMethodRequest(methodToCall).toString());
    const callResult = await session.call(methodToCall);
    // istanbul ignore next
    if (callResult.statusCode.isNotGood()) {
        warningLog(new node_opcua_types_1.CallMethodRequest(methodToCall).toString());
    }
    return callResult.statusCode;
}
//# sourceMappingURL=call_condition_refresh.js.map