"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPercentGoodData = getPercentGoodData;
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const common_1 = require("./common");
const calculate_bad_good_1 = require("./calculate_bad_good");
function calculatePercentGood(interval, options) {
    //
    // The PercentGood Aggregate defined in Table 44 performs the following calculation:
    //
    //     PercentGood = DurationGood / ProcessingInterval x 100
    // where:
    //
    // DurationGood is the result from the DurationGood *Aggregate*, calculated using the *ProcessingInterval* supplied to *PercentGood* call.
    // ProcessingInterval is the duration of interval.
    // If the last interval is a partial interval then the duration of the partial interval is used in the
    // calculation.
    // Each Aggregate is returned with timestamp of the start of the interval. StatusCodes are Good, Calculated.
    //
    const { percentGood, statusCode } = (0, calculate_bad_good_1.calculateBadAndGood)(interval, options);
    if (percentGood < 0) {
        // special case ! to indicate that no good pointhas been found in the interval
        return new node_opcua_data_value_1.DataValue({
            sourceTimestamp: interval.startTime,
            statusCode: node_opcua_status_code_1.StatusCodes.Bad,
            value: { dataType: node_opcua_variant_1.DataType.Null }
        });
    }
    const value = percentGood;
    if (statusCode.isGoodish()) {
        return new node_opcua_data_value_1.DataValue({
            sourceTimestamp: interval.startTime,
            statusCode,
            value: { dataType: node_opcua_variant_1.DataType.Double, value }
        });
    }
    return new node_opcua_data_value_1.DataValue({ sourceTimestamp: interval.startTime, statusCode, value: { dataType: node_opcua_variant_1.DataType.Null } });
}
/**
 *
 * @param node 	Retrieve the percentage of data (0 to 100) in the interval which has Good StatusCode.
 */
function getPercentGoodData(node, processingInterval, startDate, endDate, callback) {
    (0, common_1.getAggregateData)(node, processingInterval, startDate, endDate, calculatePercentGood, callback);
}
//# sourceMappingURL=percent_good.js.map