"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDurationGoodData = getDurationGoodData;
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const common_1 = require("./common");
const calculate_bad_good_1 = require("./calculate_bad_good");
function calculateDurationGood(interval, options) {
    const { durationGood, durationUnknown, statusCode } = (0, calculate_bad_good_1.calculateBadAndGood)(interval, options);
    if (durationUnknown > 0 && durationGood === 0) {
        return new node_opcua_data_value_1.DataValue({
            sourceTimestamp: interval.startTime,
            statusCode: node_opcua_status_code_1.StatusCodes.Bad
        });
    }
    const value = durationGood;
    if (statusCode.isGoodish()) {
        return new node_opcua_data_value_1.DataValue({
            sourceTimestamp: interval.startTime,
            statusCode,
            value: { dataType: node_opcua_variant_1.DataType.Double, value }
        });
    }
    return new node_opcua_data_value_1.DataValue({ sourceTimestamp: interval.startTime, statusCode, value: { dataType: node_opcua_variant_1.DataType.Null } });
}
/**Retrieve the percentage of data (0 to 100) in the interval which has Bad StatusCode. */
function getDurationGoodData(node, processingInterval, startDate, endDate, callback) {
    (0, common_1.getAggregateData)(node, processingInterval, startDate, endDate, calculateDurationGood, callback);
}
//# sourceMappingURL=duration_good.js.map