"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAverageData = getAverageData;
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const common_1 = require("./common");
function calculateIntervalAverageValue(interval, options) {
    const indexStart = interval.index;
    let statusCode;
    let isPartial = interval.isPartial;
    const isRaw = false;
    let hasBad = false;
    const values = [];
    for (let i = indexStart; i < indexStart + interval.count; i++) {
        const dataValue = interval.dataValues[i];
        if (dataValue.statusCode.equals(node_opcua_status_code_1.StatusCodes.BadNoData)) {
            isPartial = true;
            continue;
        }
        if (dataValue.statusCode.isNotGood()) {
            hasBad = true;
            continue;
        }
        values.push(dataValue.value.value);
    }
    if (isRaw) {
        if (hasBad) {
            statusCode = node_opcua_status_code_1.StatusCodes.UncertainDataSubNormal;
        }
        else {
            statusCode = node_opcua_status_code_1.StatusCodes.Good;
        }
    }
    else if (hasBad) {
        statusCode = node_opcua_status_code_1.StatusCode.makeStatusCode(node_opcua_status_code_1.StatusCodes.UncertainDataSubNormal, "HistorianCalculated");
    }
    else {
        statusCode = node_opcua_status_code_1.StatusCode.makeStatusCode(node_opcua_status_code_1.StatusCodes.Good, "HistorianCalculated");
    }
    if (values.length === 0) {
        return new node_opcua_data_value_1.DataValue({
            sourceTimestamp: interval.startTime,
            statusCode: node_opcua_status_code_1.StatusCodes.BadNoData
        });
    }
    const mean = values.reduce((p, c) => p + c, 0) / values.length;
    return new node_opcua_data_value_1.DataValue({
        sourceTimestamp: interval.startTime,
        statusCode: statusCode,
        value: {
            dataType: node_opcua_variant_1.DataType.Double,
            value: mean
        }
    });
}
function getAverageData(node, processingInterval, startDate, endDate, callback) {
    (0, common_1.getAggregateData)(node, processingInterval, startDate, endDate, calculateIntervalAverageValue, callback);
}
//# sourceMappingURL=average.js.map