import { UAVariableT } from "node-opcua-address-space-base";
import { DataType } from "node-opcua-basic-types";
import { NodeId } from "node-opcua-nodeid";

export interface InstallSetPointOptions {
    
    // the set point used in the deviation calculation. 
    // In cases where the Alarm is generated by an underlying system and if the Variable is not in the AddressSpace
    // a NULL NodeId shall be provided.
    setpointNode?: UAVariableT<number, DataType.Double> | UAVariableT<number, DataType.Float> | null;
}

export interface SetPointSupport {
    setpointNodeNode?: UAVariableT<number, DataType.Double> | UAVariableT<number, DataType.Float>;
    setpointNode: UAVariableT<NodeId, DataType.NodeId>;
}
