"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readNodeSet2XmlFile = readNodeSet2XmlFile;
exports.generateAddressSpace = generateAddressSpace;
const node_fs_1 = __importDefault(require("node:fs"));
const node_opcua_debug_1 = require("node-opcua-debug");
const __1 = require("..");
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)(__filename);
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
async function readNodeSet2XmlFile(xmlFile) {
    // istanbul ignore next
    if (!node_fs_1.default.existsSync(xmlFile)) {
        const msg = "[NODE-OPCUA-E02] generateAddressSpace : cannot find nodeset2 xml file at " + xmlFile;
        errorLog(msg);
        throw new Error(msg);
    }
    debugLog(" parsing ", xmlFile);
    const xmlData = await node_fs_1.default.promises.readFile(xmlFile, "utf-8");
    return xmlData;
}
async function generateAddressSpace(addressSpace, xmlFiles, options) {
    await (0, __1.generateAddressSpaceRaw)(addressSpace, xmlFiles, readNodeSet2XmlFile, options || {});
}
//# sourceMappingURL=generate_address_space.js.map