"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.get_empty_nodeset_filename = exports.get_mini_nodeset_filename = exports.empty_nodeset = exports.mini_nodeset = void 0;
exports.getMiniAddressSpace = getMiniAddressSpace;
/**
 * @module node-opcua-address-space
 */
const node_opcua_assert_1 = require("node-opcua-assert");
const __1 = require("..");
const nodeJS_1 = require("../nodeJS");
const get_address_space_fixture_1 = require("./get_address_space_fixture");
exports.mini_nodeset = "mini.Nodeset2.xml";
exports.empty_nodeset = "fixture_empty_nodeset2.xml";
const get_mini_nodeset_filename = () => (0, get_address_space_fixture_1.getAddressSpaceFixture)(exports.mini_nodeset);
exports.get_mini_nodeset_filename = get_mini_nodeset_filename;
const get_empty_nodeset_filename = () => (0, get_address_space_fixture_1.getAddressSpaceFixture)(exports.empty_nodeset);
exports.get_empty_nodeset_filename = get_empty_nodeset_filename;
async function getMiniAddressSpace() {
    const addressSpace = __1.AddressSpace.create();
    // register namespace 1 (our namespace);
    const serverNamespace = addressSpace.registerNamespace("http://MYNAMESPACE");
    (0, node_opcua_assert_1.assert)(serverNamespace.index === 1);
    await (0, nodeJS_1.generateAddressSpace)(addressSpace, (0, exports.get_mini_nodeset_filename)(), {});
    return addressSpace;
}
//# sourceMappingURL=get_mini_address_space.js.map