"use strict";
/* eslint-disable max-statements */
/**
 * @module node-opcua-address-space
 */
// tslint:disable:no-console
// tslint:disable:max-line-length
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create_minimalist_address_space_nodeset = create_minimalist_address_space_nodeset;
const chalk_1 = __importDefault(require("chalk"));
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const doDebug = false;
function dumpReferencesHierarchy(_addressSpace) {
    const addressSpace = _addressSpace;
    function _dump(referenceType, level) {
        console.log(level, referenceType.browseName.toString(), "(", chalk_1.default.green(referenceType
            .getAllSubtypes()
            .map((x) => x.browseName.toString())
            .join(" ")), ")");
        const subTypes = referenceType.findReferencesExAsObject("HasSubtype");
        for (const subType of subTypes) {
            _dump(subType, "     " + level);
        }
    }
    const references = addressSpace.findReferenceType(node_opcua_constants_1.ReferenceTypeIds.References);
    _dump(references, " ");
}
function create_minimalist_address_space_nodeset(addressSpace) {
    const _addressSpace = addressSpace;
    const namespace0 = addressSpace.registerNamespace("http://opcfoundation.org/UA/");
    (0, node_opcua_assert_1.assert)(namespace0.index === 0);
    function addReferenceType(browseName_, isAbstract, subtypeOf) {
        const tmp = browseName_.split("/");
        const inverseName = tmp[1];
        const browseName = tmp[0];
        const options = {
            browseName,
            inverseName,
            isAbstract,
            nodeClass: node_opcua_data_model_1.NodeClass.ReferenceType,
            nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ReferenceTypeIds[browseName]),
            references: [],
            subtypeOf
        };
        const hasSubType = (0, node_opcua_nodeid_1.resolveNodeId)("HasSubtype");
        if (subtypeOf) {
            options.references.push({
                isForward: false,
                nodeId: subtypeOf.nodeId,
                referenceType: hasSubType
            });
        }
        const node = namespace0.internalCreateNode(options);
        node.propagate_back_references();
        return node;
    }
    // add references
    {
        // before we do any thing , we need to create the HasSubtype reference
        // which is required in the first to create the hierachy of References
        const hasSubtype = addReferenceType("HasSubtype/HasSupertype");
        const references = addReferenceType("References", true);
        {
            const nonHierarchicalReferences = addReferenceType("NonHierarchicalReferences", true, references);
            {
                const hasTypeDefinition = addReferenceType("HasTypeDefinition/TypeDefinitionOf", false, nonHierarchicalReferences);
                const hasModellingRule = addReferenceType("HasModellingRule/ModellingRuleOf", false, nonHierarchicalReferences);
                const hasEncoding = addReferenceType("HasEncoding/EncodingOf", false, nonHierarchicalReferences);
            }
        }
        {
            const hierarchicalReferences = addReferenceType("HierarchicalReferences", true, references);
            {
                const hasChild = addReferenceType("HasChild/ChildOf", true, hierarchicalReferences);
                {
                    const aggregates = addReferenceType("Aggregates/AggregatedBy", true, hasChild);
                    {
                        const hasComponent = addReferenceType("HasComponent/ComponentOf", false, aggregates);
                        const hasProperty = addReferenceType("HasProperty/PropertyOf", false, aggregates);
                        const hasHistoricalConfiguration = addReferenceType("HasHistoricalConfiguration/HistoricalConfigurationOf", false, aggregates);
                    }
                }
                {
                    // add a link to hasSubType
                    hasSubtype.addReference({
                        isForward: false,
                        nodeId: hasChild,
                        referenceType: hasSubtype
                    });
                }
            }
            {
                const organizes = addReferenceType("Organizes/OrganizedBy", false, hierarchicalReferences);
            }
            {
                const hasEventSource = addReferenceType("HasEventSource/EventSourceOf", false, hierarchicalReferences);
            }
        }
    }
    if (doDebug) {
        dumpReferencesHierarchy(addressSpace);
    }
    const baseObjectType = namespace0.internalCreateNode({
        browseName: "BaseObjectType",
        isAbstract: true,
        nodeClass: node_opcua_data_model_1.NodeClass.ObjectType,
        nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ObjectTypeIds.BaseObjectType)
    });
    const baseVariableType = namespace0.internalCreateNode({
        browseName: "BaseVariableType",
        isAbstract: true,
        nodeClass: node_opcua_data_model_1.NodeClass.VariableType,
        nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.VariableTypeIds.BaseVariableType)
    });
    const propertyType = namespace0.addVariableType({
        browseName: "PropertyType",
        subtypeOf: baseVariableType
    });
    const baseDataVariableType = namespace0.internalCreateNode({
        browseName: "BaseDataVariableType",
        isAbstract: true,
        nodeClass: node_opcua_data_model_1.NodeClass.VariableType,
        nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.VariableTypeIds.BaseDataVariableType),
        subtypeOf: baseVariableType.nodeId
    });
    const modellingRule_Optional = namespace0.internalCreateNode({
        browseName: "Optional",
        nodeClass: node_opcua_data_model_1.NodeClass.Object,
        nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ObjectIds.ModellingRule_Optional)
    });
    const modellingRule_Mandatory = namespace0.internalCreateNode({
        browseName: "Mandatory",
        nodeClass: node_opcua_data_model_1.NodeClass.Object,
        nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ObjectIds.ModellingRule_Mandatory)
    });
    // add the root folder
    {
        const rootFolder = namespace0.internalCreateNode({
            browseName: "RootFolder",
            nodeClass: node_opcua_data_model_1.NodeClass.Object,
            nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ObjectIds.RootFolder)
        });
        {
            const objectsFolder = namespace0.addObject({
                browseName: "Objects",
                nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ObjectIds.ObjectsFolder),
                organizedBy: rootFolder
            });
            objectsFolder;
            (0, node_opcua_assert_1.assert)(rootFolder.getFolderElementByName("Objects").browseName.toString() === "Objects");
        }
        {
            const dataTypeFolder = namespace0.addObject({
                browseName: "DataType",
                nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.ObjectIds.DataTypesFolder),
                organizedBy: rootFolder
            });
            {
                const doubleDataType = namespace0.internalCreateNode({
                    browseName: "Double",
                    nodeClass: node_opcua_data_model_1.NodeClass.DataType,
                    nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node_opcua_constants_1.DataTypeIds.Double),
                    organizedBy: dataTypeFolder
                });
                doubleDataType;
            }
        }
    }
}
//# sourceMappingURL=create_minimalist_address_space_nodeset.js.map