/**
 * @module node-opcua-address-space
 */
import { InstantiateVariableOptions, ModellingRuleType, UAVariable, UAVariableType } from "node-opcua-address-space-base";
import { NodeClass, AttributeIds } from "node-opcua-data-model";
import { DataValue } from "node-opcua-data-value";
import { NodeId, NodeIdLike } from "node-opcua-nodeid";
import { UInt32 } from "node-opcua-basic-types";
import { DataType } from "node-opcua-variant";
import { SessionContext } from "../source/session_context";
import { AddressSpacePrivate } from "./address_space_private";
import { BaseNodeImpl, InternalBaseNodeOptions } from "./base_node_impl";
interface InstantiateS {
    propertyOf?: any;
    componentOf?: any;
    modellingRule?: ModellingRuleType;
    copyAlsoModellingRules?: boolean;
    copyAlsoAllOptionals?: boolean;
}
export declare function topMostParentIsObjectTypeOrVariableType(addressSpace: AddressSpacePrivate, options: InstantiateS): boolean;
export interface UAVariableTypeOptions extends InternalBaseNodeOptions {
    /**
     * This attribute indicates whether the Value attribute of the Variable is an array and how many dimensions the array has.
     * It may have the following values:
     *   * n > 1: the Value is an array with the specified number of dimensions.
     *   * OneDimension (1): The value is an array with one dimension.
     *   * OneOrMoreDimensions (0): The value is an array with one or more dimensions.
     *   * Scalar (−1): The value is not an array.
     *   * Any (−2): The value can be a scalar or an array with any number of dimensions.
     *   * ScalarOrOneDimension (−3): The value can be a scalar or a one dimensional array.
     *   * All DataTypes are considered to be scalar, even if they have array-like semantics like ByteString and String.
     */
    valueRank?: number;
    arrayDimensions?: number[] | null;
    historizing?: boolean;
    isAbstract?: boolean;
    value?: any;
    dataType: NodeIdLike;
}
export declare class UAVariableTypeImpl extends BaseNodeImpl implements UAVariableType {
    readonly nodeClass = NodeClass.VariableType;
    get subtypeOf(): NodeId | null;
    get subtypeOfObj(): UAVariableType | null;
    isSubtypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UAVariableType>;
    /** @deprecated - use  isSubtypeOf instead */
    isSupertypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UAVariableType>;
    readonly isAbstract: boolean;
    dataType: NodeId;
    valueRank: number;
    arrayDimensions: UInt32[] | null;
    readonly minimumSamplingInterval: number;
    readonly value: any;
    historizing: boolean;
    constructor(options: UAVariableTypeOptions);
    readAttribute(context: SessionContext | null, attributeId: AttributeIds): DataValue;
    toString(): string;
    /**
     * instantiate an object of this UAVariableType
     * The instantiation takes care of object type inheritance when constructing inner properties
   
     * Note : HasComponent usage scope
     *
     * ```text
     *    Source          |     Destination
     * -------------------+---------------------------
     *  Object            | Object, Variable,Method
     *  ObjectType        |
     * -------------------+---------------------------
     *  DataVariable      | Variable
     *  DataVariableType  |
     * ```
     *
     *  see : OPCUA 1.03 page 44 $6.4 Instances of ObjectTypes and VariableTypes
     */
    instantiate(options: InstantiateVariableOptions): UAVariable;
    getBasicDataType(): DataType;
}
export declare function assertUnusedChildBrowseName(addressSpace: AddressSpacePrivate, options: InstantiateVariableOptions): void;
export {};
