import { NodeClass } from "node-opcua-data-model";
import { AttributeIds } from "node-opcua-data-model";
import { DataValue } from "node-opcua-data-value";
import { NodeId } from "node-opcua-nodeid";
import { InstantiateObjectOptions, ISessionContext, UAObject, UAObjectType } from "node-opcua-address-space-base";
import { BaseNodeImpl } from "./base_node_impl";
export declare class UAObjectTypeImpl extends BaseNodeImpl implements UAObjectType {
    readonly nodeClass = NodeClass.ObjectType;
    readonly isAbstract: boolean;
    /**
     * returns true if the object has some opcua methods
     */
    get hasMethods(): boolean;
    get subtypeOf(): NodeId | null;
    get subtypeOfObj(): UAObjectType | null;
    isSubtypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UAObjectType>;
    /** @deprecated - use  isSubtypeOf instead */
    isSupertypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UAObjectType>;
    constructor(options: any);
    readAttribute(context: ISessionContext, attributeId: AttributeIds): DataValue;
    /**
     * instantiate an object of this UAObjectType
     * The instantiation takes care of object type inheritance when constructing inner properties and components.

     * @param options
     * @param options.browseName
     * @param [options.description]
     * @param [options.organizedBy] the parent Folder holding this object
     * @param [options.componentOf] the parent Object holding this object
     * @param [options.addInOf]
     * @param [options.notifierOf]
     * @param [options.eventSourceOf]
     * @param [options.optionals = [] name of the optional child to create
     * @param [options.modellingRule]
     * @param [options.encodingOf]
     *
     *
     * Note : HasComponent usage scope
     *
     *    Source          |     Destination
     * -------------------+---------------------------
     *  Object            | Object, Variable,Method
     *  ObjectType        |
     * -------------------+---------------------------
     *  DataVariable      | Variable
     *  DataVariableType  |
     */
    instantiate(options: InstantiateObjectOptions): UAObject;
    toString(): string;
}
