import { NodeClass, QualifiedNameLike } from "node-opcua-data-model";
import { AttributeIds } from "node-opcua-data-model";
import { DataValue } from "node-opcua-data-value";
import { ExpandedNodeId, NodeId } from "node-opcua-nodeid";
import { NumericRange } from "node-opcua-numeric-range";
import { DataTypeDefinition, EnumDefinition, EnumFieldOptions, StructureDefinition, StructureFieldOptions } from "node-opcua-types";
import { DataType } from "node-opcua-variant";
import { UAObject, ISessionContext, UADataType, BaseNode } from "node-opcua-address-space-base";
import { ExtensionObjectConstructorFuncWithSchema } from "../source/interfaces/extension_object_constructor";
import { BaseNodeImpl, InternalBaseNodeOptions } from "./base_node_impl";
import { ToStringOption } from "./base_node_private";
export interface UADataTypeImpl {
    _extensionObjectConstructor: ExtensionObjectConstructorFuncWithSchema;
}
export interface IEnumItem {
    name: string;
    value: number;
}
export interface EnumerationInfo {
    nameIndex: {
        [id: string]: IEnumItem;
    };
    valueIndex: {
        [id: number]: IEnumItem;
    };
}
export interface UADataTypeOptions extends InternalBaseNodeOptions {
    partialDefinition: StructureFieldOptions[] | EnumFieldOptions[];
    isUnion?: boolean;
    isAbstract?: boolean;
    symbolicName?: string;
}
export declare class UADataTypeImpl extends BaseNodeImpl implements UADataType {
    readonly nodeClass = NodeClass.DataType;
    readonly definitionName: string;
    readonly symbolicName: string;
    /**
     * returns true if this is a super type of baseType
     *
     * @example
     *
     *    var dataTypeDouble = addressSpace.findDataType("Double");
     *    var dataTypeNumber = addressSpace.findDataType("Number");
     *    assert(dataTypeDouble.isSubtypeOf(dataTypeNumber));
     *    assert(!dataTypeNumber.isSubtypeOf(dataTypeDouble));
     *
     */
    get subtypeOf(): NodeId | null;
    get subtypeOfObj(): UADataType | null;
    /** @deprecated */
    isSupertypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UADataType>;
    isSubtypeOf: import("./tool_isSubtypeOf").IsSubtypeOfFunc<UADataType>;
    readonly isAbstract: boolean;
    private $isUnion?;
    private enumStrings?;
    private enumValues?;
    private $partialDefinition?;
    private $fullDefinition?;
    constructor(options: UADataTypeOptions);
    get basicDataType(): DataType;
    getBasicDataType(): DataType;
    readAttribute(context: ISessionContext | null, attributeId: AttributeIds, indexRange?: NumericRange, dataEncoding?: QualifiedNameLike | null): DataValue;
    getEncodingDefinition(encoding_name: string): string | null;
    getEncodingNode(encoding_name: string): UAObject | null;
    getEncodingNodeId(encoding_name: string): ExpandedNodeId | null;
    /**
     * returns the encoding of this node's
     * TODO objects have 2 encodings : XML and Binaries
     */
    get binaryEncoding(): BaseNode | null;
    get binaryEncodingDefinition(): string | null;
    get binaryEncodingNodeId(): ExpandedNodeId | null;
    get xmlEncoding(): BaseNode | null;
    get xmlEncodingNodeId(): ExpandedNodeId | null;
    get xmlEncodingDefinition(): string | null;
    get jsonEncoding(): BaseNode | null;
    get jsonEncodingNodeId(): ExpandedNodeId | null;
    _getEnumerationInfo(): EnumerationInfo;
    isStructure(): boolean;
    getStructureDefinition(): StructureDefinition;
    isEnumeration(): boolean;
    getEnumDefinition(): EnumDefinition;
    _getDefinition(): DataTypeDefinition | null;
    getDefinition(): DataTypeDefinition;
    install_extra_properties(): void;
    toString(): string;
}
export declare function DataType_toString(this: UADataTypeImpl, options: ToStringOption): void;
