import { NodeClass, QualifiedNameOptions } from "node-opcua-data-model";
import { NodeId, NodeIdLike } from "node-opcua-nodeid";
import { BaseNode, UAReference, UAReferenceType } from "node-opcua-address-space-base";
export declare const NamespaceOptions: {
    nodeIdNameSeparator: string;
};
type Suffix = string;
export interface AddressSpacePartial {
    findNode(nodeId: NodeIdLike): BaseNode | null;
    findReferenceType(refType: NodeIdLike, namespaceIndex?: number): UAReferenceType | null;
}
export interface ConstructNodeIdOptions {
    nodeId?: string | NodeIdLike | BaseNode | null;
    browseName: QualifiedNameOptions;
    nodeClass?: NodeClass;
    references?: UAReference[];
    registerSymbolicNames?: boolean;
}
export type NodeEntry = [string, number, NodeClass];
export type NodeEntry1 = [string, number, string];
export declare class NodeIdManager {
    private _cacheSymbolicName;
    private _cacheSymbolicNameRev;
    private _internal_id_counter;
    private namespaceIndex;
    private addressSpace;
    constructor(namespaceIndex: number, addressSpace: AddressSpacePartial);
    setSymbols(symbols: NodeEntry1[]): void;
    getSymbols(): NodeEntry1[];
    getSymbolCSV(): string;
    buildNewNodeId(): NodeId;
    constructNodeId(options: ConstructNodeIdOptions): NodeId;
    private _constructNodeId;
    findParentNodeId(options: ConstructNodeIdOptions): [NodeId, Suffix] | null;
    private _isInCache;
}
export {};
