import { AccessRestrictionsFlag, QualifiedNameLike } from "node-opcua-data-model";
import { NodeId } from "node-opcua-nodeid";
import { RolePermissionType, RolePermissionTypeOptions } from "node-opcua-types";
import { DataType, VariantOptions } from "node-opcua-variant";
import { AddEnumerationTypeOptions, AddMethodOptions, AddObjectOptions, AddObjectTypeOptions, AddReferenceOpts, AddReferenceTypeOptions, AddVariableOptions, AddVariableTypeOptions, AddViewOptions, AddYArrayItemOptions, BaseNode, CreateDataTypeOptions, CreateNodeOptions, RequiredModel, UADataType, UAEventType, UAMethod, UAObject, UAObjectType, UAReferenceType, UAVariable, UAVariableType, UAView } from "node-opcua-address-space-base";
import { UAAnalogItem, UADataItem, UAInitialState, UAState } from "node-opcua-nodeset-ua";
import { AddMultiStateDiscreteOptions, AddMultiStateValueDiscreteOptions, AddTwoStateDiscreteOptions, AddTwoStateVariableOptions } from "../source/address_space_ts";
import { UAStateMachineEx } from "../source/interfaces/state_machine/ua_state_machine_type";
import { UATransitionEx } from "../source/interfaces/state_machine/ua_transition_ex";
import { InstantiateAlarmConditionOptions, InstantiateLimitAlarmOptions, InstantiateOffNormalAlarmOptions, UATwoStateDiscreteEx, UAYArrayItemEx } from "../source";
import { AddAnalogDataItemOptions, AddDataItemOptions } from "../source/namespace_data_access";
import { UATwoStateVariableEx } from "../source/ua_two_state_variable_ex";
import { UAMultiStateValueDiscreteEx } from "../source/interfaces/data_access/ua_multistate_value_discrete_ex";
import { UAAlarmConditionEx } from "../source/interfaces/alarms_and_conditions/ua_alarm_condition_ex";
import { UADiscreteAlarmEx } from "../source/interfaces/alarms_and_conditions/ua_discrete_alarm_ex";
import { UAExclusiveDeviationAlarmEx } from "../source/interfaces/alarms_and_conditions/ua_exclusive_deviation_alarm_ex";
import { UAExclusiveLimitAlarmEx } from "../source/interfaces/alarms_and_conditions/ua_exclusive_limit_alarm_ex";
import { UALimitAlarmEx } from "../source/interfaces/alarms_and_conditions/ua_limit_alarm_ex";
import { UANonExclusiveDeviationAlarmEx } from "../source/interfaces/alarms_and_conditions/ua_non_exclusive_deviation_alarm_ex";
import { UANonExclusiveLimitAlarmEx } from "../source/interfaces/alarms_and_conditions/ua_non_exclusive_limit_alarm_ex";
import { UAConditionEx } from "../source/interfaces/alarms_and_conditions/ua_condition_ex";
import { InstantiateExclusiveDeviationAlarmOptions } from "../source/interfaces/alarms_and_conditions/instantiate_exclusive_deviation_alarm_options";
import { InstantiateNonExclusiveLimitAlarmOptions } from "../source/interfaces/alarms_and_conditions/instantiate_non_exclusive_limit_alarm_options";
import { InstantiateNonExclusiveDeviationAlarmOptions } from "../source/interfaces/alarms_and_conditions/instantiate_non_exclusive_deviation_alarm_options";
import { AddressSpacePrivate } from "./address_space_private";
import { UAAcknowledgeableConditionImpl } from "./alarms_and_conditions";
import { UAOffNormalAlarmEx } from "./alarms_and_conditions/ua_off_normal_alarm_impl";
import { UAMultiStateDiscreteImpl } from "./data_access/ua_multistate_discrete_impl";
import { NamespacePrivate } from "./namespace_private";
import { ConstructNodeIdOptions } from "./nodeid_manager";
export interface AddFolderOptions {
    browseName: QualifiedNameLike;
}
interface NamespaceConstructorOptions {
    addressSpace: AddressSpacePrivate;
    index: number;
    namespaceUri: string;
    publicationDate: Date;
    version: string;
}
/**
 *
 * @constructor
 * @params options {Object}
 * @params options.namespaceUri {string}
 * @params options.addressSpace {IAddressSpace}
 * @params options.index {number}
 * @params options.version="" {string}
 * @params options.publicationDate="" {Date}
 *
 */
export declare class NamespaceImpl implements NamespacePrivate {
    static _handle_hierarchy_parent: typeof _handle_hierarchy_parent;
    static isNonEmptyQualifiedName: typeof isNonEmptyQualifiedName;
    readonly namespaceUri: string;
    addressSpace: AddressSpacePrivate;
    readonly index: number;
    emulateVersion103: boolean;
    version: string;
    publicationDate: Date;
    registerSymbolicNames: boolean;
    private _requiredModels?;
    private _objectTypeMap;
    private _variableTypeMap;
    private _referenceTypeMap;
    private _dataTypeMap;
    private _referenceTypeMapInv;
    private _nodeIdManager;
    private _nodeid_index;
    private _aliases;
    private defaultAccessRestrictions?;
    private defaultRolePermissions?;
    constructor(options: NamespaceConstructorOptions);
    getDefaultNamespace(): NamespacePrivate;
    dispose(): void;
    nodeIterator(): IterableIterator<BaseNode>;
    _objectTypeIterator(): IterableIterator<UAObjectType>;
    _objectTypeCount(): number;
    _variableTypeIterator(): IterableIterator<UAVariableType>;
    _variableTypeCount(): number;
    _dataTypeIterator(): IterableIterator<UADataType>;
    _dataTypeCount(): number;
    _referenceTypeIterator(): IterableIterator<UAReferenceType>;
    _referenceTypeCount(): number;
    _aliasCount(): number;
    findNode2(nodeId: NodeId): BaseNode | null;
    findNode(nodeId: string | NodeId): BaseNode | null;
    /**
     *
     * @param objectTypeName {String}
     * @return {UAObjectType|null}
     */
    findObjectType(objectTypeName: string): UAObjectType | null;
    /**
     *
     * @param variableTypeName {String}
     * @returns {UAVariableType|null}
     */
    findVariableType(variableTypeName: string): UAVariableType | null;
    /**
     *
     * @param dataTypeName {String}
     * @returns {UADataType|null}
     */
    findDataType(dataTypeName: string): UADataType | null;
    /**
     *
     * @param referenceTypeName {String}
     * @returns  {ReferenceType|null}
     */
    findReferenceType(referenceTypeName: string): UAReferenceType | null;
    /**
     * find a ReferenceType by its inverse name.

     * @param inverseName {String} the inverse name of the ReferenceType to find
     * @return {ReferenceType}
     */
    findReferenceTypeFromInverseName(inverseName: string): UAReferenceType | null;
    /**
     *

     * @param alias_name {String} the alias name
     * @param nodeId {NodeId} NodeId must belong to this namespace
     */
    addAlias(alias_name: string, nodeId: NodeId): void;
    resolveAlias(name: string): NodeId | null;
    /**
     * add a new Object type to the address space

     * @param options
     * @param options.browseName {String} the object type name
     * @param [options.displayName] {String|LocalizedText} the display name
     * @param [options.subtypeOf="BaseObjectType"] {String|NodeId|BaseNode} the base class
     * @param [options.nodeId] {String|NodeId} an optional nodeId for this objectType,
     *                                         if not provided a new nodeId will be created
     * @param [options.isAbstract = false] {Boolean}
     * @param [options.eventNotifier = 0] {Integer}
     * @param [options.postInstantiateFunc = null] {Function}
     *
     */
    addObjectType(options: AddObjectTypeOptions): UAObjectType;
    /**
     * add a new Variable type to the address space

     * @param options
     * @param options.browseName {String} the object type name
     * @param [options.displayName] {String|LocalizedText} the display name
     * @param [options.subtypeOf="BaseVariableType"] {String|NodeId|BaseNode} the base class
     * @param [options.nodeId] {String|NodeId} an optional nodeId for this objectType,
     *                                             if not provided a new nodeId will be created
     * @param [options.isAbstract = false] {Boolean}
     * @param options.dataType {String|NodeId} the variable DataType
     * @param [options.valueRank = -1]
     * @param [options.arrayDimensions = null] { Array<Int>>
     *
     */
    addVariableType(options: AddVariableTypeOptions): UAVariableType;
    /**
     * add a variable as a component of the parent node
     */
    addVariable(options: AddVariableOptions): UAVariable;
    addView(options: AddViewOptions): UAView;
    addObject(options1: AddObjectOptions): UAObject;
    /**
     *

     * @param parentFolder
     * @param options {String|Object}
     * @param options.browseName {String} the name of the folder
     * @param [options.nodeId] {NodeId}. An optional nodeId for this object
     *
     * @return {BaseNode}
     */
    addFolder(parentFolder: UAObject, options: AddFolderOptions | string): UAObject;
    /**

     * @param options
     * @param options.isAbstract
     * @param options.browseName
     * @param options.inverseName
     */
    addReferenceType(options: AddReferenceTypeOptions): UAReferenceType;
    /**
     */
    addMultiStateDiscrete<T, DT extends DataType>(options: AddMultiStateDiscreteOptions): UAMultiStateDiscreteImpl<T, DT>;
    /**

     */
    createDataType(options: CreateDataTypeOptions): UADataType;
    /**

     * @param options
     * @param options.nodeClass
     * @param [options.nodeVersion {String} = "0" ] install nodeVersion
     * @param [options.modellingRule {String} = null]
     * @internal
     */
    createNode(options: CreateNodeOptions): BaseNode;
    /**
     * remove the specified Node from the address space
     *

     * @param  nodeOrNodeId
     *
     *
     */
    deleteNode(nodeOrNodeId: NodeId | BaseNode): void;
    /**
     * @internal
     */
    getStandardsNodeIds(): {
        referenceTypeIds: {
            [key: string]: string;
        };
        objectTypeIds: {
            [key: string]: string;
        };
    };
    /**
     * add a new event type to the address space

     * @param options
     * @param options.browseName {String} the eventType name
     * @param [options.subtypeOf ="BaseEventType"]
     * @param [options.isAbstract = true]
     * @return {UAObjectType} : the object type
     *
     * @example
     *
     *      var evtType = namespace.addEventType({
     *          browseName: "MyAuditEventType",
     *          subtypeOf:  "AuditEventType"
     *      });
     *      var myConditionType = namespace.addEventType({
     *          browseName: "MyConditionType",
     *          subtypeOf:  "ConditionType",
     *          isAbstract: false
     *      });
     *
     */
    addEventType(options: any): UAObjectType;
    /**
     *
     */
    addDataItem<T, DT extends DataType>(options: AddDataItemOptions): UADataItem<T, DT>;
    /**
     *

     *
     * AnalogDataItem DataItems that represent continuously-variable physical quantities ( e.g., length, temperature),
     * in contrast to the digital representation of data in discrete  items
     * NOTE Typical examples are the values provided by temperature sensors or pressure sensors. OPC UA defines a
     * specific UAVariableType to identify an AnalogItem. Properties describe the possible ranges of  AnalogItems.
     *
     *
     * @example:
     *
     *
     *   namespace.add_analog_dataItem({
     *      componentOf: parentObject,
     *      browseName: "TemperatureSensor",
     *
     *      definition: "(tempA -25) + tempB",
     *      valuePrecision: 0.5,
     *      //-
     *      instrumentRange: { low: 100 , high: 200}, // optional
     *      engineeringUnitsRange: { low: 100 , high: 200}, // mandatory
     *      engineeringUnits: standardUnits.degree_celsius,, // optional
     *
     *      // access level
     *      accessLevel: 1
     *      minimumSamplingInterval: 10,
     *
     *   });
     *
  
     * @return {UAVariable}
     */
    addAnalogDataItem<T, DT extends DataType>(options: AddAnalogDataItemOptions): UAAnalogItem<T, DT>;
    /**
     *

     * @param options {Object}
     * @param options.browseName {String}
     * @param [options.nodeId  {NodeId}]
     * @param [options.value {UInt32} = 0 }
     * @param options.enumValues { EnumValueType[]| {Key,Value} }
     * @return {Object|UAVariable}
     *
     * @example
     *
     *
     *      namespace.addMultiStateValueDiscrete({
     *          componentOf:parentObj,
     *          browseName: "myVar",
     *          enumValues: {
     *              "Red":    0xFF0000,
     *              "Green":  0x00FF00,
     *              "Blue":   0x0000FF
     *          }
     *      });
     *      addMultiStateValueDiscrete(parentObj,{
     *          browseName: "myVar",
     *          enumValues: [
     *              {
     *                 value: 0xFF0000,
     *                 displayName: "Red",
     *                 description: " The color Red"
     *              },
     *              {
     *                 value: 0x00FF000,
     *                 displayName: "Green",
     *                 description: " The color Green"
     *              },
     *              {
     *                 value: 0x0000FF,
     *                 displayName: "Blue",
     *                 description: " The color Blue"
     *              }
     *
     *          ]
     *      });
     */
    addMultiStateValueDiscrete<T, DT extends DataType>(options: AddMultiStateValueDiscreteOptions): UAMultiStateValueDiscreteEx<T, DT>;
    /**
     *

     * @param options
     * @param options.componentOf {NodeId}
     * @param options.browseName {String}
     * @param options.title {String}
     * @param [options.instrumentRange]
     * @param [options.instrumentRange.low] {Double}
     * @param [options.instrumentRange.high] {Double}
     * @param options.engineeringUnitsRange.low {Double}
     * @param options.engineeringUnitsRange.high {Double}
     * @param options.engineeringUnits {String}
     * @param [options.nodeId = {NodeId}]
     * @param options.accessLevel
     * @param options.userAccessLevel
     * @param options.title {String}
     * @param options.axisScaleType {AxisScaleEnumeration}
     *
     * @param options.xAxisDefinition {AxisInformation}
     * @param options.xAxisDefinition.engineeringUnits  EURange
     * @param options.xAxisDefinition.range
     * @param options.xAxisDefinition.range.low
     * @param options.xAxisDefinition.range.high
     * @param options.xAxisDefinition.title  {LocalizedText}
     * @param options.xAxisDefinition.axisScaleType {AxisScaleEnumeration}
     * @param options.xAxisDefinition.axisSteps = <null>  {Array<Double>}
     * @param options.value
     */
    addYArrayItem<DT extends DataType.Double | DataType.Float>(options: AddYArrayItemOptions): UAYArrayItemEx<DT>;
    /**

     * @param parentObject {Object}
     * @param options {Object}
     * @param [options.nodeId=null] {NodeId} the object nodeid.
     * @param [options.browseName=""] {String} the object browse name.
     * @param [options.description=""] {String} the object description.
     * @param options.inputArguments  {Array<Argument>}
     * @param options.outputArguments {Array<Argument>}
     * @return {Object}
     */
    addMethod(parentObject: UAObject, options: AddMethodOptions): UAMethod;
    /**
     *

     * @param options
     * @param options.browseName  {String}
     * @param options.enumeration {Array}
     * @param options.enumeration[].displayName {String|LocalizedText}
     * @param options.enumeration[].value       {Number}
     * @param options.enumeration[].description {String|LocalizedText|null}
     */
    addEnumerationType(options: AddEnumerationTypeOptions): UADataType;
    toNodeset2XML(): string;
    setRequiredModels(requiredModels: RequiredModel[]): void;
    getRequiredModels(): RequiredModel[] | undefined;
    /**
    */
    addState(component: UAStateMachineEx, stateName: QualifiedNameLike, stateNumber: number, isInitialState: boolean): UAState | UAInitialState;
    /**
     */
    addTransition(component: UAStateMachineEx, fromState: string, toState: string, transitionNumber: number, browseName?: QualifiedNameLike): UATransitionEx;
    /**

     *
     * @return {UATwoStateVariable}
     */
    addTwoStateVariable(options: AddTwoStateVariableOptions): UATwoStateVariableEx;
    /**

     *
     * Add a TwoStateDiscrete Variable
     * @return {UATwoStateDiscrete}
     */
    addTwoStateDiscrete(options: AddTwoStateDiscreteOptions): UATwoStateDiscreteEx;
    instantiateCondition(conditionTypeId: UAEventType | NodeId | string, options: any, data: Record<string, VariantOptions>): UAConditionEx;
    instantiateAcknowledgeableCondition(conditionTypeId: UAEventType | NodeId | string, options: InstantiateAlarmConditionOptions, data?: Record<string, VariantOptions>): UAAcknowledgeableConditionImpl;
    instantiateAlarmCondition(alarmConditionTypeId: UAEventType | NodeId | string, options: InstantiateAlarmConditionOptions, data?: Record<string, VariantOptions>): UAAlarmConditionEx;
    instantiateLimitAlarm(limitAlarmTypeId: UAEventType | NodeId | string, options: InstantiateLimitAlarmOptions, data?: Record<string, VariantOptions>): UALimitAlarmEx;
    instantiateExclusiveLimitAlarm(exclusiveLimitAlarmTypeId: UAEventType | NodeId | string, options: InstantiateLimitAlarmOptions, data?: Record<string, VariantOptions>): UAExclusiveLimitAlarmEx;
    instantiateExclusiveDeviationAlarm(options: InstantiateExclusiveDeviationAlarmOptions, data?: Record<string, VariantOptions>): UAExclusiveDeviationAlarmEx;
    instantiateNonExclusiveLimitAlarm(nonExclusiveLimitAlarmTypeId: UAEventType | NodeId | string, options: InstantiateNonExclusiveLimitAlarmOptions, data?: Record<string, VariantOptions>): UANonExclusiveLimitAlarmEx;
    instantiateNonExclusiveDeviationAlarm(options: InstantiateNonExclusiveDeviationAlarmOptions, data?: Record<string, VariantOptions>): UANonExclusiveDeviationAlarmEx;
    instantiateDiscreteAlarm(discreteAlarmType: UAEventType | NodeId | string, options: InstantiateAlarmConditionOptions, data?: Record<string, VariantOptions>): UADiscreteAlarmEx;
    instantiateOffNormalAlarm(options: InstantiateOffNormalAlarmOptions, data?: Record<string, VariantOptions>): UAOffNormalAlarmEx;
    setDefaultRolePermissions(rolePermissions: RolePermissionTypeOptions[] | null): void;
    getDefaultRolePermissions(): RolePermissionType[] | null;
    setDefaultAccessRestrictions(accessRestrictions: AccessRestrictionsFlag): void;
    getDefaultAccessRestrictions(): AccessRestrictionsFlag;
    constructNodeId(options: ConstructNodeIdOptions): NodeId;
    _register(node: BaseNode): void;
    /**

     * @internal
     */
    internalCreateNode(options: CreateNodeOptions): BaseNode;
    _deleteNode(node: BaseNode): void;
    private _addObjectOrVariableType;
    private _registerObjectType;
    private _registerVariableType;
    private _registerReferenceType;
    private _registerDataType;
    private _unregisterObjectType;
    private _unregisterVariableType;
    /**
     * @private
     */
    private _addVariable;
    /**
     * @private
     */
    private _addMethod;
}
export declare function _handle_hierarchy_parent(addressSpace: AddressSpacePrivate, references: AddReferenceOpts[], options: any): void;
export declare function isNonEmptyQualifiedName(browseName: QualifiedNameLike): boolean;
export {};
