import { NodeId } from "node-opcua-nodeid";
import { ExtensionObject } from "node-opcua-extension-object";
import { UADynamicVariableArray, UAObject, UAVariable } from "node-opcua-address-space-base";
import { UAVariableImpl } from "./ua_variable_impl";
/**
 *
 * create a node Variable that contains a array of ExtensionObject of a given type
 */
export declare function createExtObjArrayNode<T extends ExtensionObject>(parentFolder: UAObject, options: any): UADynamicVariableArray<T>;
export declare function bindExtObjArrayNode<T extends ExtensionObject>(uaArrayVariableNode: UADynamicVariableArray<T>, variableTypeNodeId: string | NodeId, indexPropertyName: string): UAVariable;
/**

 * add a new element in a ExtensionObject Array variable
 * @param options {Object}   data used to construct the underlying ExtensionObject
 * @param uaArrayVariableNode {UAVariable}
 * @return {UAVariable}
 *
 */
export declare function addElement<T extends ExtensionObject>(options: UAVariableImpl | ExtensionObject | Record<string, unknown>, uaArrayVariableNode: UADynamicVariableArray<T>): UAVariable;
/**
 *
 */
export declare function removeElement<T extends ExtensionObject>(uaArrayVariableNode: UADynamicVariableArray<T>, element: number | UAVariable | ((a: T) => boolean)): void;
