"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventData = void 0;
/**
 * @module node-opcua-address-space.Private
 */
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_types_1 = require("node-opcua-types");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_utils_1 = require("node-opcua-utils");
/**
 */
class EventData {
    eventId;
    $eventDataSource;
    $cache;
    constructor(eventTypeNode) {
        this.$cache = {
            __values: {},
            __nodeIdToNode: {},
            __pathToNodeId: {},
            __nodeIdToFullPath: {}
        };
        this.eventId = new node_opcua_nodeid_1.NodeId();
        this.$eventDataSource = eventTypeNode;
    }
    _createValue(fullBrowsePath, node, variant) {
        const eventData = this;
        (0, node_opcua_assert_1.assert)(!eventData[fullBrowsePath], "already exists " + fullBrowsePath);
        const lowerName = fullBrowsePath.split(".").map(node_opcua_utils_1.lowerFirstLetter).join(".");
        eventData[lowerName] = node_opcua_variant_1.Variant.coerce(variant);
        this.$cache.__pathToNodeId[fullBrowsePath] = node.nodeId;
        this.$cache.__nodeIdToNode[node.nodeId.toString()] = node;
        this.$cache.__nodeIdToFullPath[node.nodeId.toString()] = fullBrowsePath;
        this.$cache.__values[node.nodeId.toString()] = eventData[lowerName];
    }
    _browse(browsePath) {
        if (!(0, node_opcua_nodeid_1.sameNodeId)(browsePath.startingNode, this.$eventDataSource.nodeId)) {
            return null;
        }
        const fullBrowsePath = (browsePath.relativePath.elements || []).map((b => b.targetName.toString())).join(".");
        const nodeId = this.$cache.__pathToNodeId[fullBrowsePath];
        if (!nodeId)
            return null;
        return new node_opcua_types_1.BrowsePathResult({
            statusCode: node_opcua_status_code_1.StatusCodes.Good,
            targets: [{
                    remainingPathIndex: 0,
                    targetId: (0, node_opcua_nodeid_1.coerceExpandedNodeId)(nodeId),
                }]
        });
    }
    _readValue(nodeId) {
        const key = nodeId.toString();
        const cached_value = this.$cache.__values[key];
        if (cached_value) {
            return cached_value;
        }
        return null;
    }
}
exports.EventData = EventData;
//# sourceMappingURL=event_data.js.map