import { NodeId } from "node-opcua-nodeid";
import { BrowsePath, BrowsePathResult } from "node-opcua-types";
import { Variant, VariantLike } from "node-opcua-variant";
import { BaseNode, IEventData } from "node-opcua-address-space-base";
type NodeIdString = string;
type FullBrowsePath = string;
/**
 */
export declare class EventData implements IEventData {
    eventId: NodeId;
    $eventDataSource: BaseNode;
    $cache: {
        __values: {
            [key: NodeIdString]: Variant;
        };
        __nodeIdToNode: {
            [key: NodeIdString]: BaseNode;
        };
        __pathToNodeId: {
            [key: FullBrowsePath]: NodeId;
        };
        __nodeIdToFullPath: {
            [key: NodeIdString]: FullBrowsePath;
        };
    };
    constructor(eventTypeNode: BaseNode);
    _createValue(fullBrowsePath: string, node: BaseNode, variant: VariantLike): void;
    _browse(browsePath: BrowsePath): BrowsePathResult | null;
    _readValue(nodeId: NodeId): Variant | null;
}
export {};
