"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UATwoStateDiscreteImpl = void 0;
exports.promoteToTwoStateDiscrete = promoteToTwoStateDiscrete;
exports._addTwoStateDiscrete = _addTwoStateDiscrete;
const node_opcua_assert_1 = __importDefault(require("node-opcua-assert"));
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_variant_1 = require("node-opcua-variant");
const node_opcua_constants_1 = require("node-opcua-constants");
const ua_variable_impl_1 = require("../ua_variable_impl");
const register_node_promoter_1 = require("../../source/loader/register_node_promoter");
const add_dataItem_stuff_1 = require("./add_dataItem_stuff");
class UATwoStateDiscreteImpl extends ua_variable_impl_1.UAVariableImpl {
    /*
     * @private
     */
    _post_initialize() {
        // The StatusCode SemanticsChanged bit shall be set if any of the FalseState or TrueState
        // (changes can cause misinterpretation by users or (scripting) programs) Properties are changed
        // (see section 5.2 for additional information).
        const handler = this.handle_semantic_changed.bind(this);
        const falseState = this.getPropertyByName("FalseState");
        /* istanbul ignore else */
        if (falseState) {
            falseState.on("value_changed", handler);
        }
        else {
            console.warn("warning: UATwoStateDiscrete -> a FalseState property is mandatory ", this.browseName.toString(), this.nodeId.toString());
        }
        const trueState = this.getPropertyByName("TrueState");
        /* istanbul ignore else */
        if (trueState) {
            trueState.on("value_changed", handler);
        }
        else {
            console.warn("waring: UATwoStateDiscrete -> a TrueState property is mandatory", this.browseName.toString(), this.nodeId.toString());
        }
    }
    setValue(value, options) {
        if (typeof value === "boolean") {
            this.setValueFromSource({ dataType: node_opcua_variant_1.DataType.Boolean, value });
        }
        else {
            const text = (typeof value === "string" ? value : value.text) || "";
            if (text === this.getTrueStateAsString()) {
                this.setValue(true, options);
            }
            else if (text === this.getFalseStateAsString()) {
                this.setValue(false, options);
            }
            else {
                throw new Error("setValue invalid value " + value);
            }
        }
    }
    getValue() {
        return this.readValue().value.value;
    }
    getValueAsString() {
        if (this.getValue()) {
            return this.getTrueStateAsString();
        }
        else {
            return this.getFalseStateAsString();
        }
    }
    getTrueStateAsString() {
        return this.trueState.readValue().value.value.text || "";
    }
    getFalseStateAsString() {
        return this.falseState.readValue().value.value.text || "";
    }
    clone(options1, optionalFilter, extraInfo) {
        const variable1 = ua_variable_impl_1.UAVariableImpl.prototype.clone.call(this, options1, optionalFilter, extraInfo);
        promoteToTwoStateDiscrete(variable1);
        return variable1;
    }
}
exports.UATwoStateDiscreteImpl = UATwoStateDiscreteImpl;
function promoteToTwoStateDiscrete(node) {
    if (node instanceof UATwoStateDiscreteImpl) {
        return node; // already promoted
    }
    Object.setPrototypeOf(node, UATwoStateDiscreteImpl.prototype);
    (0, node_opcua_assert_1.default)(node instanceof UATwoStateDiscreteImpl, "should now  be a UATwoStateDiscrete");
    const _node = node;
    _node._post_initialize();
    return _node;
}
(0, register_node_promoter_1.registerNodePromoter)(node_opcua_constants_1.VariableTypeIds.TwoStateDiscreteType, promoteToTwoStateDiscrete);
function _addTwoStateDiscrete(namespace, options) {
    const addressSpace = namespace.addressSpace;
    (0, node_opcua_assert_1.default)(!Object.prototype.hasOwnProperty.call(options, "ValuePrecision"));
    const twoStateDiscreteType = addressSpace.findVariableType("TwoStateDiscreteType");
    if (!twoStateDiscreteType) {
        throw new Error("expecting TwoStateDiscreteType to be defined , check nodeset xml file");
    }
    let value;
    if (typeof options.value === "boolean") {
        value = new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.Boolean, value: !!options.value });
    }
    else {
        value = options.value;
    }
    // todo : if options.typeDefinition is specified,
    // todo : refactor to use twoStateDiscreteType.instantiate
    const variable = namespace.addVariable({
        accessLevel: options.accessLevel,
        browseName: options.browseName,
        displayName: options.displayName,
        componentOf: options.componentOf,
        propertyOf: options.propertyOf,
        dataType: node_opcua_variant_1.DataType.Boolean,
        nodeId: options.nodeId,
        typeDefinition: twoStateDiscreteType.nodeId,
        userAccessLevel: options.userAccessLevel,
        modellingRule: options.modellingRule,
        minimumSamplingInterval: options.minimumSamplingInterval,
        value
    });
    /*
    const dataValueVerif = variable.readValue();
    assert(dataValueVerif.value.dataType === DataType.Boolean);
    */
    const handler = variable.handle_semantic_changed.bind(variable);
    (0, add_dataItem_stuff_1.add_dataItem_stuff)(variable, options);
    const trueStateNode = namespace.addVariable({
        browseName: { name: "TrueState", namespaceIndex: 0 },
        dataType: "LocalizedText",
        minimumSamplingInterval: 0,
        propertyOf: variable,
        typeDefinition: "PropertyType",
        modellingRule: options.modellingRule ? "Mandatory" : undefined,
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.LocalizedText,
            value: (0, node_opcua_data_model_1.coerceLocalizedText)(options.trueState || "ON")
        })
    });
    trueStateNode.on("value_changed", handler);
    const falseStateNode = namespace.addVariable({
        browseName: { name: "FalseState", namespaceIndex: 0 },
        dataType: "LocalizedText",
        minimumSamplingInterval: 0,
        propertyOf: variable,
        typeDefinition: "PropertyType",
        modellingRule: options.modellingRule ? "Mandatory" : undefined,
        value: new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.LocalizedText,
            value: (0, node_opcua_data_model_1.coerceLocalizedText)(options.falseState || "OFF")
        })
    });
    falseStateNode.on("value_changed", handler);
    variable.install_extra_properties();
    return promoteToTwoStateDiscrete(variable);
}
//# sourceMappingURL=ua_two_state_discrete_impl.js.map