import { LocalizedText } from "node-opcua-data-model";
import { NodeId } from "node-opcua-nodeid";
import { ReferenceDescription } from "node-opcua-types";
import { IAddressSpace, UAReferenceType, CloneExtraInfo, CloneFilter, BaseNode, UAVariable, UAMethod, UAObject, UAObjectType, UAVariableType, ISessionContext, UAReference, CloneOptions, UAVariableT } from "node-opcua-address-space-base";
import { BaseNodeImpl } from "./base_node_impl";
import { DataType } from "node-opcua-basic-types";
interface BaseNodeCacheInner {
    typeDefinition?: NodeId;
    typeDefinitionObj?: UAVariableType | UAObjectType | null;
    _aggregates?: BaseNode[];
    _components?: BaseNode[];
    _properties?: BaseNode[];
    _children?: BaseNode[];
    _versionNode?: UAVariableT<string, DataType.String> | null;
    _notifiers?: BaseNode[];
    _eventSources?: BaseNode[];
    _methods?: UAMethod[];
    _ref?: Map<string, UAReference[]>;
    _encoding?: Map<string, UAObject | null>;
    _subtype_idx?: Map<string, UAReferenceType> | null;
    _subtype_idxVersion?: number;
    _allSubTypes?: UAReferenceType[] | null;
    _allSubTypesVersion?: number;
    _subtypeOfObj?: BaseNode | null;
}
export type UAReferenceWithNodeRef = UAReference & {
    node: BaseNode;
};
export type HierarchicalIndexMap = Map<string, UAReferenceWithNodeRef | UAReferenceWithNodeRef[]>;
interface BaseNodeCache {
    _childByNameMap?: HierarchicalIndexMap;
    __address_space: IAddressSpace | null;
    _browseFilter?: (this: BaseNode, context?: ISessionContext) => boolean;
    _cache: BaseNodeCacheInner;
    _description?: LocalizedText;
    _displayName: LocalizedText[];
    _parent?: BaseNode | null;
    _back_referenceIdx: Map<string, UAReference>;
    _referenceIdx: Map<string, UAReference>;
}
export declare function BaseNode_initPrivate(self: BaseNode): BaseNodeCache;
export declare function BaseNode_removePrivate(self: BaseNode): void;
export declare function BaseNode_getPrivate(self: BaseNode): BaseNodeCache;
export declare function BaseNode_getCache(node: BaseNode): BaseNodeCacheInner;
export declare function BaseNode_clearCache(node: BaseNode): void;
export interface ToStringOption {
    level: number;
    cycleDetector: any;
    padding: string;
    add(someLine: string): void;
    indent(a: string, b: string | null): void;
}
export declare class ToStringBuilder implements ToStringOption {
    level: number;
    cycleDetector: any;
    padding: string;
    private str;
    constructor();
    add(line: string): void;
    toString(): string;
    indent(str: string, padding: string | null): string;
}
export declare function BaseNode_toString(this: BaseNode, options: ToStringOption): void;
export declare function BaseNode_References_toString(this: BaseNode, options: ToStringOption): void;
export declare function UAVariableType_toString(this: UAVariableType, options: ToStringOption): void;
export declare function UAVariable_toString(this: UAVariable, options: ToStringOption): void;
export declare function UAObject_toString(this: UAObject, options: ToStringOption): void;
export declare function UAObjectType_toString(this: UAObjectType, options: ToStringOption): void;
export declare function valueRankToString(valueRank: number): string;
export declare function VariableOrVariableType_toString(this: UAVariableType | UAVariable, options: ToStringOption): void;
export declare function _clone_hierarchical_references(nodeToClone: UAObject | UAVariable | UAMethod | UAObjectType | UAVariableType, newParent: UAObject | UAVariable | UAMethod, copyAlsoModellingRules: boolean, optionalFilter: CloneFilter, extraInfo: CloneExtraInfo, browseNameMap: Set<string>): void;
export declare function _clone_non_hierarchical_references(nodeToClone: UAObject | UAVariable | UAMethod | UAObjectType | UAVariableType, newParent: BaseNode, copyAlsoModellingRules: boolean, optionalFilter: CloneFilter, extraInfo: CloneExtraInfo, browseNameMap: Set<string>): void;
/**

 * @private
 */
export declare function _clone<T extends UAObject | UAVariable | UAMethod>(originalNode: T, Constructor: new (options: any) => T, options: CloneOptions, optionalFilter: CloneFilter, extraInfo: CloneExtraInfo): T;
export declare function _handle_HierarchicalReference(node: BaseNode, reference: UAReference): void;
export declare function _get_HierarchicalReference(node: BaseNode): HierarchicalIndexMap;
export declare function _remove_HierarchicalReference(node: BaseNodeImpl, reference: UAReference): void;
export declare function _constructReferenceDescription(addressSpace: IAddressSpace, references: UAReference[], resultMask: number): ReferenceDescription[];
export declare function BaseNode_remove_backward_reference(this: BaseNodeImpl, reference: UAReference): void;
export declare function BaseNode_add_backward_reference(this: BaseNodeImpl, reference: UAReference): void;
export {};
