"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.apply_condition_refresh = apply_condition_refresh;
const ua_condition_impl_1 = require("./alarms_and_conditions/ua_condition_impl");
function apply_condition_refresh(cache) {
    // visit all notifiers recursively
    cache = cache || new Map();
    const notifiers = this.getNotifiers();
    const eventSources = this.getEventSources();
    const conditions = this.findReferencesAsObject("HasCondition", true);
    for (const condition of conditions) {
        if (condition instanceof ua_condition_impl_1.UAConditionImpl) {
            condition._resend_conditionEvents();
        }
    }
    const arr = [].concat(notifiers, eventSources);
    for (const notifier of arr) {
        const key = notifier.nodeId.toString();
        if (!cache.has(key)) {
            cache.set(key, notifier);
            if (notifier._conditionRefresh) {
                notifier._conditionRefresh(cache);
            }
        }
    }
}
//# sourceMappingURL=apply_condition_refresh.js.map