"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MandatoryChildOrRequestedOptionalFilter = void 0;
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_address_space_base_1 = require("node-opcua-address-space-base");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_data_model_1 = require("node-opcua-data-model");
// const debugLog = make_debugLog(__filename);
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)(__filename);
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
const doTrace = (0, node_opcua_debug_1.checkDebugFlag)("INSTANTIATE");
const traceLog = errorLog;
class MandatoryChildOrRequestedOptionalFilter {
    instance;
    optionalsMap;
    references;
    copyAlsoAllOptionals = false;
    constructor(instance, copyAlsoAllOptionals, optionalsMap) {
        this.copyAlsoAllOptionals = copyAlsoAllOptionals;
        // should we clone the node to be a component or propertyOf of a instance
        (0, node_opcua_assert_1.assert)(null !== instance);
        this.optionalsMap = optionalsMap;
        this.instance = instance;
        this.references = instance.findReferencesEx("Aggregates", node_opcua_data_model_1.BrowseDirection.Forward);
    }
    shouldKeep(node) {
        const addressSpace = node.addressSpace;
        const alreadyIn = this.references.filter((r) => {
            const n = addressSpace.findNode(r.nodeId);
            // istanbul ignore next
            if (!n) {
                warningLog(" cannot find node ", r.nodeId.toString());
                return false;
            }
            return n.browseName.name.toString() === node.browseName.name.toString();
        });
        if (alreadyIn.length > 0) {
            (0, node_opcua_assert_1.assert)(alreadyIn.length === 1, "Duplication found ?");
            // a child with the same browse name has already been install
            // probably from a SuperClass, we should ignore this.
            return false; // ignore
        }
        const modellingRule = node.modellingRule;
        switch (modellingRule) {
            case null:
            case undefined:
                // istanbul ignore next
                doTrace &&
                    traceLog("node ", (0, node_opcua_address_space_base_1.fullPath2)(node), " has no modellingRule ", node ? (0, node_opcua_address_space_base_1.fullPath2)(node) : "");
                /**
                 * in some badly generated NodeSet2.xml file, the modellingRule is not specified
                 *
                 * but in some other NodeSet2.xml, this means that the data are only attached to the Type node and shall not be
                 * instantiate in the corresponding instance (example is the state variable of a finite state machine that are only
                 * defined in the Type node)
                 *
                 * we should not consider it as an error, and treat it as not present
                 */
                return false;
            case "Mandatory":
                return true; // keep;
            case "Optional":
                // only if in requested optionals
                return this.copyAlsoAllOptionals || (node.browseName.name in this.optionalsMap);
            case "OptionalPlaceholder":
                return false; // ignored
            default:
                return false; // ignored
        }
    }
    filterFor(childInstance) {
        const browseName = childInstance.browseName.name;
        let map = Object.create(null);
        if (browseName in this.optionalsMap) {
            map = this.optionalsMap[browseName];
        }
        // istanbul ignore next
        doTrace && traceLog("filterFor ", browseName, map);
        const newFilter = new MandatoryChildOrRequestedOptionalFilter(childInstance, false, map);
        return newFilter;
    }
}
exports.MandatoryChildOrRequestedOptionalFilter = MandatoryChildOrRequestedOptionalFilter;
//# sourceMappingURL=_mandatory_child_or_requested_optional_filter.js.map