"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initialize_properties_and_components = initialize_properties_and_components;
/**
 * @module node-opcua-address-space
 */
// tslint:disable:max-classes-per-file
// tslint:disable:no-console
const chalk_1 = __importDefault(require("chalk"));
const node_opcua_address_space_base_1 = require("node-opcua-address-space-base");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const make_optionals_map_1 = require("../source/helpers/make_optionals_map");
const base_node_private_1 = require("./base_node_private");
const _mandatory_child_or_requested_optional_filter_1 = require("./_mandatory_child_or_requested_optional_filter");
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)(__filename);
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
// eslint-disable-next-line prefer-const
let doTrace = (0, node_opcua_debug_1.checkDebugFlag)("INSTANTIATE");
const traceLog = errorLog;
// install properties and components on a instantiated Object
//
// based on their ModelingRule
//  => Mandatory                 => Installed
//  => Optional                  => Not Installed , unless it appear in optionals array
//  => OptionalPlaceHolder       => Not Installed
//  => null (no modelling rule ) => Not Installed
//
function _initialize_properties_and_components(instance, topMostType, typeDefinitionNode, copyAlsoModellingRules, copyAlsoAllOptionals, optionalsMap, extraInfo, browseNameMap) {
    if (doTrace) {
        warningLog("instance browseName =", instance.browseName.toString());
        warningLog("typeNode            =", typeDefinitionNode.browseName.toString());
        warningLog("optionalsMap        =", Object.keys(optionalsMap).join(" "));
        const c = typeDefinitionNode.findReferencesEx("Aggregates");
        warningLog("typeDefinition aggregates      =", c.map((x) => x.node.browseName.toString()).join(" "));
    }
    optionalsMap = optionalsMap || {};
    if ((0, node_opcua_nodeid_1.sameNodeId)(topMostType.nodeId, typeDefinitionNode.nodeId)) {
        return; // nothing to do
    }
    const filter = new _mandatory_child_or_requested_optional_filter_1.MandatoryChildOrRequestedOptionalFilter(instance, copyAlsoAllOptionals, optionalsMap);
    doTrace &&
        traceLog(chalk_1.default.cyan(extraInfo.pad(), "cloning relevant member of typeDefinition class"), typeDefinitionNode.browseName.toString() + "\n optionals" + (JSON.stringify(optionalsMap)));
    (0, base_node_private_1._clone_hierarchical_references)(typeDefinitionNode, instance, copyAlsoModellingRules, filter, extraInfo, browseNameMap);
    // now apply recursion on baseTypeDefinition  to get properties and components from base class
    const baseTypeDefinitionNodeId = typeDefinitionNode.subtypeOf;
    const baseTypeDefinition = typeDefinitionNode.subtypeOfObj;
    doTrace &&
        traceLog(chalk_1.default.cyan(extraInfo.pad(), "now apply recursion on baseTypeDefinition  to get properties and components from base class"), baseTypeDefinition.browseName.toString());
    // istanbul ignore next
    if (!baseTypeDefinition) {
        throw new Error(chalk_1.default.red("Cannot find object with nodeId ") + baseTypeDefinitionNodeId);
    }
    extraInfo.level++;
    _initialize_properties_and_components(instance, topMostType, baseTypeDefinition, copyAlsoModellingRules, copyAlsoAllOptionals, optionalsMap, extraInfo, browseNameMap);
    extraInfo.level--;
}
function initialize_properties_and_components(instance, topMostType, nodeType, copyAlsoModellingRules, copyAlsoAllOptionals, optionals) {
    const extraInfo = new node_opcua_address_space_base_1.CloneHelper();
    extraInfo.pushContext({
        clonedParent: instance,
        originalParent: nodeType
    });
    extraInfo.registerClonedObject({
        clonedNode: instance,
        originalNode: nodeType
    });
    const optionalsMap = (0, make_optionals_map_1.makeOptionalsMap)(optionals);
    const browseNameMap = new Set();
    _initialize_properties_and_components(instance, topMostType, nodeType, copyAlsoModellingRules, copyAlsoAllOptionals, optionalsMap, extraInfo, browseNameMap);
    (0, node_opcua_address_space_base_1.reconstructFunctionalGroupType)(extraInfo);
    (0, node_opcua_address_space_base_1.reconstructNonHierarchicalReferences)(extraInfo);
}
//# sourceMappingURL=_instantiate_helpers.js.map