import { INamespace, ModellingRuleType, UAObject, UAObjectType, UAVariableT } from "node-opcua-address-space-base";
import { DataType } from "node-opcua-basic-types";
import { QualifiedName, QualifiedNameLike } from "node-opcua-data-model";
import { NodeIdLike } from "node-opcua-nodeid";
export interface InstantiateAddInOptions {
    defaultName?: QualifiedNameLike;
    modellingRule?: ModellingRuleType;
    addInOf: UAObject | UAObjectType;
    copyAlsoModellingRules?: boolean;
    namespace?: INamespace;
    nodeId?: NodeIdLike;
}
export declare function instantiateAddIn(objectType: UAObjectType, options: InstantiateAddInOptions): UAObject;
export declare function addDefaultInstanceBrowseName(objectType: UAObjectType, defaultBrowseName: QualifiedName | string): UAVariableT<QualifiedName, DataType.QualifiedName>;
