"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setNamespaceMetaData = setNamespaceMetaData;
const node_opcua_variant_1 = require("node-opcua-variant");
function specialEncode(namespaceUri) {
    return namespaceUri;
}
function setNamespaceMetaData(namespace) {
    // NamespaceMetadataType
    const addressSpace = namespace.addressSpace;
    const namespaceMetadataType = addressSpace.findObjectType("NamespaceMetadataType");
    const namespaces = addressSpace.rootFolder.objects.server.getChildByName("Namespaces");
    /* istanbul ignore next */
    if (!namespaces) {
        throw new Error("Cannot find namespacesType node under server object");
    }
    /* istanbul ignore next */
    if (!namespaceMetadataType) {
        throw new Error("cannot find NamespaceMetadataType");
    }
    const deriveName = specialEncode(namespace.namespaceUri);
    const existingMetaData = namespaces.getComponentByName(deriveName, namespace.index);
    /* istanbul ignore next */
    if (existingMetaData) {
        throw new Error("INamespace meta data already exists for " + deriveName);
    }
    const metaData = namespaceMetadataType.instantiate({
        browseName: deriveName,
        componentOf: namespaces,
        optionals: [
            "DefaultRolePermissions",
            "DefaultAccessRestrictions",
            "DefaultUserRolePermissions"
            // "NamespaceFile"
        ]
    });
    // FIX ME namespaceUri collides with UAObject.namespaceUri  !!!!
    const namespaceUri = metaData.getChildByName("NamespaceUri");
    namespaceUri.setValueFromSource({ dataType: node_opcua_variant_1.DataType.String, value: namespace.namespaceUri });
    const namespacePublicationDate = metaData.namespacePublicationDate;
    namespacePublicationDate.setValueFromSource({ dataType: node_opcua_variant_1.DataType.DateTime, value: new Date() });
    const namespaceVersion = metaData.namespaceVersion;
    namespaceVersion.setValueFromSource({ dataType: node_opcua_variant_1.DataType.String, value: "1.0.0" });
    metaData.defaultAccessRestrictions?.bindVariable({
        get: () => new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.UInt16,
            value: namespace.getDefaultAccessRestrictions()
        })
    }, true);
    metaData.defaultRolePermissions?.bindVariable({
        get: () => new node_opcua_variant_1.Variant({
            dataType: node_opcua_variant_1.DataType.ExtensionObject,
            arrayType: node_opcua_variant_1.VariantArrayType.Array,
            value: namespace.getDefaultRolePermissions()
        })
    }, true);
}
//# sourceMappingURL=set_namespace_meta_data.js.map