import { IAddressSpace } from "node-opcua-address-space-base";
import { ExtensionObject } from "node-opcua-extension-object";
import { NodeId } from "node-opcua-nodeid";
import { VariantOptions } from "node-opcua-variant";
import { ParserLike, ReaderStateParserLike } from "node-opcua-xml2json";
export type Task = (addressSpace2: IAddressSpace) => Promise<void>;
interface Parser {
    parent: Parser | any;
}
export interface ListOfTParser<T> extends Parser {
    listData: T[];
    parent: Parser;
    parser: {
        [key: string]: Parser | any;
    };
}
export interface ListOfExtensionObjectParser extends ListOfTParser<ExtensionObject> {
    isDeferred: boolean;
    listExtensionObject: (ExtensionObject | null)[];
    listExtensionObjectXML: {
        xmlEncodingNodeId: NodeId;
        bodyXML: string;
    }[];
    parser: {
        ExtensionObject: ParserLike;
    };
}
export declare function makeVariantReader<T extends ReaderStateParserLike>(setValue: (self: T, data: VariantOptions) => void, setDeferredValue: (self: T, data: VariantOptions, deferedTask: () => ExtensionObject | ExtensionObject[] | null) => void, postExtensionObjectDecoding: (task: (addressSpace: IAddressSpace) => Promise<void>) => void, translateNodeId: (nodeId: string) => NodeId): ReaderStateParserLike;
export {};
