import { QualifiedNameOptions, QualifiedName } from "node-opcua-data-model";
import { NodeId } from "node-opcua-nodeid";
import { ReaderStateParserLike } from "node-opcua-xml2json";
interface QualifiedNameParserL1 extends ReaderStateParserLike {
    value: QualifiedName | null;
    qualifiedName: QualifiedNameOptions;
}
export interface QualifiedNameParserL2 {
    parent: QualifiedNameParserL1;
    text: string;
}
export declare const makeQualifiedNameParser: (_translateNodeId: (nodeId: string) => NodeId) => {
    QualifiedName: {
        init(this: QualifiedNameParserL1): void;
        parser: {
            Name: {
                finish(this: QualifiedNameParserL2): void;
            };
            NamespaceIndex: {
                finish(this: QualifiedNameParserL2): void;
            };
        };
        finish(this: QualifiedNameParserL1): void;
    };
};
export {};
