"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.localizedText_parser = void 0;
const node_opcua_data_model_1 = require("node-opcua-data-model");
exports.localizedText_parser = {
    LocalizedText: {
        init() {
            this.localizedText = { locale: undefined, text: undefined };
            this.value = null;
        },
        parser: {
            Locale: {
                finish() {
                    this.parent.localizedText = this.parent.localizedText || { text: undefined };
                    this.parent.localizedText.locale = this.text.trim();
                }
            },
            Text: {
                finish() {
                    this.parent.localizedText = this.parent.localizedText || { text: undefined };
                    this.parent.localizedText.text = this.text.trim();
                }
            }
        },
        finish() {
            this.value = (0, node_opcua_data_model_1.coerceLocalizedText)(this.localizedText);
        }
    }
};
//# sourceMappingURL=localized_text_parser.js.map