import { NodeId } from "node-opcua-nodeid";
import { EnumDefinition, StructureDefinition } from "node-opcua-types";
import { DataType } from "node-opcua-variant";
import { ReaderState, ReaderStateParserLike } from "node-opcua-xml2json";
export interface TypeInfo1 {
    name: string;
    definition: StructureDefinition;
}
export interface TypeInfo2 {
    name: string;
    definition: EnumDefinition;
}
export interface TypeInfo3 {
    name: string;
    definition: {
        dataType: DataType;
    };
}
export type TypeInfo = TypeInfo1 | TypeInfo2 | TypeInfo3;
export interface DefinitionMap2 {
    findDefinition(dataTypeNodeId: NodeId): TypeInfo;
}
export declare function makeXmlExtensionObjectReader(dataTypeNodeId: NodeId, definitionMap: DefinitionMap2, readerMap: Map<string, ReaderStateParserLike>, translateNodeId: (nodeId: string) => NodeId): ReaderState;
