import { CallbackT } from "node-opcua-status-code";
import { IAddressSpace, RequiredModel } from "node-opcua-address-space-base";
import { NodeSetLoaderOptions } from "../interfaces/nodeset_loader_options";
interface Model extends RequiredModel {
    requiredModel: RequiredModel[];
}
interface NodesetInfo {
    namespaceUris: string[];
    models: Model[];
}
interface NodesetDesc {
    index: number;
    xmlData: string;
    namespaceModel: NodesetInfo;
}
/**
 * Detect order of namespace loading
 */
export declare function preLoad(xmlFiles: string[], xmlLoader: (nodeset2xmlUri: string) => Promise<string>): Promise<NodesetDesc[]>;
export declare function findOrder(nodesetDescs: NodesetDesc[]): number[];
/**
 * @param addressSpace the addressSpace to populate
 * @xmlFiles: a lis of xml files
 * @param xmlLoader - a helper function to return the content of the xml file
 */
export declare function generateAddressSpaceRaw(addressSpace: IAddressSpace, xmlFiles: string | string[], xmlLoader: (nodeset2xmlUri: string) => Promise<string>, options: NodeSetLoaderOptions): Promise<void>;
export type XmlLoaderFunc = (nodeset2xmlUri: string, callback: CallbackT<string>) => void;
export type XmlLoaderAsyncFunc = (nodeset2xmlUri: string) => Promise<string>;
export {};
