"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureDatatypeExtracted = ensureDatatypeExtracted;
exports.ensureDatatypeExtractedWithCallback = ensureDatatypeExtractedWithCallback;
const node_opcua_client_dynamic_extension_object_1 = require("node-opcua-client-dynamic-extension-object");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_factory_1 = require("node-opcua-factory");
const pseudo_session_1 = require("../pseudo_session");
const construct_namespace_dependency_1 = require("../../src/nodeset_tools/construct_namespace_dependency");
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
function fixDefinition103(addressSpace, namespaceArray, dataTypeManager) {
    // fix datatype _getDefinition();
    for (let namespaceIndex = 1; namespaceIndex < namespaceArray.length; namespaceIndex++) {
        const df = dataTypeManager.getDataTypeFactory(namespaceIndex);
        for (const s of df.getStructureIterator()) {
            const dataType = addressSpace.findDataType(s.schema.dataTypeNodeId);
            if (!s.constructor) {
                continue;
            }
            if (!dataType) {
                continue;
            }
            if (dataType.$partialDefinition && dataType.$partialDefinition.length) {
                continue;
            }
            // debugLog(" Exploration", dataType.browseName.toString());
            if (!dataType.$partialDefinition || (dataType.$partialDefinition.length === 0 && s.schema.fields.length > 0)) {
                const sd = (0, node_opcua_client_dynamic_extension_object_1.convertStructureTypeSchemaToStructureDefinition)(s.schema);
                dataType.$partialDefinition = sd.fields || undefined;
            }
        }
    }
}
async function ensureDatatypeExtracted(addressSpace) {
    const addressSpacePriv = addressSpace;
    if (!addressSpacePriv.$$extraDataTypeManager) {
        const dataTypeManager = new node_opcua_client_dynamic_extension_object_1.ExtraDataTypeManager();
        const namespaceArray = addressSpace.getNamespaceArray().map((n) => n.namespaceUri);
        debugLog("INamespace Array = ", namespaceArray.join("\n                   "));
        dataTypeManager.setNamespaceArray(namespaceArray);
        addressSpacePriv.$$extraDataTypeManager = dataTypeManager;
        const factories = [(0, node_opcua_factory_1.getStandardDataTypeFactory)()];
        const priorityTable = (0, construct_namespace_dependency_1.constructNamespacePriorityTable)(addressSpace).priorityTable;
        for (let namespaceIndex = 1; namespaceIndex < namespaceArray.length; namespaceIndex++) {
            const namespace = addressSpace.getNamespace(namespaceIndex);
            if (false) {
                console.log("namespaceIndex = ", namespaceIndex);
                console.log("namespace = ", namespace.namespaceUri);
                console.log("factories = ", factories.map((f) => f.targetNamespace).join(" "));
                // find dependent namespaces
                let dependency = (0, construct_namespace_dependency_1.constructNamespaceDependency)(namespace);
                // remove last element that is my namespace
                dependency = dependency.filter((ns) => ns.index !== namespaceIndex);
                const dependFactories = dependency.map((ns) => {
                    const df = factories[ns.index];
                    if (!df) {
                        console.log("namespaceIndex = ", namespaceIndex);
                        console.log("namespace = ", namespace.namespaceUri);
                        console.log("priorityTable", priorityTable);
                        console.log(dependency.map((ns) => `${ns.index} ${ns.namespaceUri}`).join("\n"));
                        throw new Error("Cannot find factory for namespace " + ns.namespaceUri);
                    }
                    return df;
                });
                //            getStandardDataTypeFactory()
                const dataTypeFactory1 = new node_opcua_factory_1.DataTypeFactory(dependFactories);
            }
            const dataTypeFactory1 = new node_opcua_factory_1.DataTypeFactory([...factories]);
            dataTypeFactory1.targetNamespace = namespace.namespaceUri;
            factories.push(dataTypeFactory1);
            // xx console.log("factories = ", factories.map((f) => f.targetNamespace).join(" "));
            dataTypeManager.registerDataTypeFactory(namespaceIndex, dataTypeFactory1);
        }
        // inject simple types
        // now extract structure and enumeration from old form
        const session = new pseudo_session_1.PseudoSession(addressSpace);
        await (0, node_opcua_client_dynamic_extension_object_1.populateDataTypeManager)(session, dataTypeManager, node_opcua_client_dynamic_extension_object_1.DataTypeExtractStrategy.Auto);
        // turn old <=103 structure to have valid DataTypeDefinition
        fixDefinition103(addressSpace, namespaceArray, dataTypeManager);
    }
    return addressSpacePriv.$$extraDataTypeManager;
}
function ensureDatatypeExtractedWithCallback(addressSpace, callback) {
    ensureDatatypeExtracted(addressSpace)
        .then((result) => callback(null, result))
        .catch((err) => callback(err));
}
//# sourceMappingURL=ensure_datatype_extracted.js.map