"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeDefinitionMap = makeDefinitionMap;
exports.decodeXmlExtensionObject = decodeXmlExtensionObject;
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_types_1 = require("node-opcua-types");
const node_opcua_xml2json_1 = require("node-opcua-xml2json");
const make_xml_extension_object_parser_1 = require("./make_xml_extension_object_parser");
const doDebug = (0, node_opcua_debug_1.checkDebugFlag)(__filename);
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
function encodingNodeIdToDataTypeNode(addressSpace, encodingNodeId) {
    const encodingNode = addressSpace.findNode(encodingNodeId);
    // istanbul ignore next
    if (!encodingNode) {
        throw new Error("findDataTypeNode:  Cannot find encoding NodeId" + encodingNodeId.toString());
    }
    const refs = encodingNode.findReferences("HasEncoding", false);
    const dataTypes = refs.map((ref) => addressSpace.findNode(ref.nodeId)).filter((obj) => obj !== null);
    // istanbul ignore next
    if (dataTypes.length !== 1) {
        throw new Error("Internal Error");
    }
    const dataTypeNode = dataTypes[0];
    return dataTypeNode;
}
function makeDefinitionMap(addressSpace) {
    return {
        findDefinition(dataTypeNodeId) {
            const dataTypeNode = addressSpace.findDataType(dataTypeNodeId);
            if (!dataTypeNode) {
                throw new Error("findDefinition: cannot find dataType " + dataTypeNodeId.toString());
            }
            if (dataTypeNode.nodeClass !== node_opcua_types_1.NodeClass.DataType) {
                throw new Error("Expecting a DataType node here");
            }
            const name = dataTypeNode.browseName.name || "";
            if (dataTypeNode.isStructure()) {
                const definition = dataTypeNode.getStructureDefinition();
                return { name, definition };
            }
            else if (dataTypeNode.isEnumeration()) {
                const definition = dataTypeNode.getEnumDefinition();
                return { name, definition };
            }
            else {
                const dataType = dataTypeNode.getBasicDataType();
                return { name, definition: { dataType } };
            }
        }
    };
}
function decodeXmlExtensionObject(addressSpace, encodingNodeId, xmlBody, translateNodeId) {
    const definitionMap = makeDefinitionMap(addressSpace);
    const dataType = encodingNodeIdToDataTypeNode(addressSpace, encodingNodeId);
    //  const { name, definition } = definitionMap.findDefinition(dataType.nodeId);
    // const hasOptionalFields = definition.fields!.some((field) => field.isOptional);
    const reader = (0, make_xml_extension_object_parser_1.makeXmlExtensionObjectReader)(dataType.nodeId, definitionMap, new Map(), translateNodeId);
    const parser2 = new node_opcua_xml2json_1.Xml2Json(reader);
    const pojo = parser2.parseString(xmlBody);
    const userDefinedExtensionObject = addressSpace.constructExtensionObject(dataType, pojo);
    // istanbul ignore next
    if (doDebug) {
        debugLog("userDefinedExtensionObject", userDefinedExtensionObject.toString());
    }
    //
    return userDefinedExtensionObject;
}
//# sourceMappingURL=decode_xml_extension_object.js.map