"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeOptionalsMap = makeOptionalsMap;
/**
 * @module node-opcua-address-space
 */
const node_opcua_assert_1 = require("node-opcua-assert");
function makeOptionalsMap(optionals) {
    // make sure to use Object.create(null); to create a object with no prototype
    // so that we prevent prototype pollution
    const resultMap = Object.create(null);
    if (!optionals) {
        return resultMap;
    }
    (0, node_opcua_assert_1.assert)(optionals instanceof Array);
    function insertInMap(map, s) {
        const key = s[0];
        if (!map[key]) {
            // make sure to use Object.create(null); to create a object with no prototype
            // so that we prevent prototype pollution
            map[key] = Object.create(null);
        }
        if (s.length > 1) {
            insertInMap(map[key], s.splice(1));
        }
    }
    for (const opt of optionals) {
        const s = opt.split(".");
        insertInMap(resultMap, s);
    }
    return resultMap;
}
//# sourceMappingURL=make_optionals_map.js.map