"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.coerceEnumValues = coerceEnumValues;
/**
 * @module node-opcua-address-space
 */
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_types_1 = require("node-opcua-types");
function coerceEnumValues(enumValues) {
    if (Array.isArray(enumValues)) {
        //
        return enumValues.map((en) => {
            (0, node_opcua_assert_1.assert)(Object.prototype.hasOwnProperty.call(en, "value"));
            (0, node_opcua_assert_1.assert)(Object.prototype.hasOwnProperty.call(en, "displayName"));
            return new node_opcua_types_1.EnumValueType({
                displayName: (0, node_opcua_data_model_1.coerceLocalizedText)(en.displayName),
                value: (0, node_opcua_basic_types_1.coerceInt64)(en.value || 0)
            });
        });
    }
    else {
        return coerceEnumValues(Object.entries(enumValues).map((entry) => {
            const [key, value] = entry;
            return new node_opcua_types_1.EnumValueType({
                description: (0, node_opcua_data_model_1.coerceLocalizedText)(key),
                displayName: (0, node_opcua_data_model_1.coerceLocalizedText)(key),
                value: (0, node_opcua_basic_types_1.coerceInt64)(value)
            });
        }));
    }
}
//# sourceMappingURL=coerce_enum_value.js.map